/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.1
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.gdal.gdal;

import org.gdal.osr.SpatialReference;
import org.gdal.gdalconst.gdalconst;
import org.gdal.gdal.Dimension;
import java.util.Vector;
import java.util.List;
import java.util.ArrayList;
import java.lang.Integer;

public class MDArray {
  private long swigCPtr;
  protected boolean swigCMemOwn;

  protected MDArray(long cPtr, boolean cMemoryOwn) {
    if (cPtr == 0)
        throw new RuntimeException();
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(MDArray obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        gdalJNI.delete_MDArray(swigCPtr);
      }
      swigCPtr = 0;
    }
  }


   public Dimension[] GetDimensions() {

       long size = GetDimensionCount();

       if (size > Integer.MAX_VALUE)
           throw new IllegalArgumentException("java array can hold at most "+Integer.MAX_VALUE+" values.");

       Dimension[] arr = new Dimension[(int) size];

       for (int i = 0; i < size; i++) {
           Dimension dim = GetDimension(i);
           arr[i] = dim;
       }

       return arr;
   }

   private long[] defaultSteps(int numDims) {

       long[] retVal = new long[numDims];

       for (int i = 0; i < numDims; i++) {
           retVal[i] = 1;
       }

       return retVal;
   }

   private long[] defaultStrides(long[] counts) {

       int numDims = counts.length;

       long[] retVal = new long[numDims];

       if (numDims>0)
       {
           retVal[numDims-1] = 1;
           for (int i = numDims - 2; i >= 0; i--) {
               retVal[i] = retVal[i+1] * counts[i+1];
           }
       }

       return retVal;
   }

   public boolean Read(long[] starts, long[] counts, long[] steps, byte[] outputBuffer) {
       return Read(starts, counts, steps, defaultStrides(counts), outputBuffer);
   }

   public boolean Read(long[] starts, long[] counts, long[] steps, short[] outputBuffer) {
       return Read(starts, counts, steps, defaultStrides(counts), outputBuffer);
   }

   public boolean Read(long[] starts, long[] counts, long[] steps, int[] outputBuffer) {
       return Read(starts, counts, steps, defaultStrides(counts), outputBuffer);
   }

   public boolean Read(long[] starts, long[] counts, long[] steps, long[] outputBuffer) {
       return Read(starts, counts, steps, defaultStrides(counts), outputBuffer);
   }

   public boolean Read(long[] starts, long[] counts, long[] steps, float[] outputBuffer) {
       return Read(starts, counts, steps, defaultStrides(counts), outputBuffer);
   }

   public boolean Read(long[] starts, long[] counts, long[] steps, double[] outputBuffer) {
       return Read(starts, counts, steps, defaultStrides(counts), outputBuffer);
   }

   public boolean Read(long[] starts, long[] counts, byte[] outputBuffer) {
       return Read(starts, counts, defaultSteps(counts.length), outputBuffer);
   }

   public boolean Read(long[] starts, long[] counts, short[] outputBuffer) {
       return Read(starts, counts, defaultSteps(counts.length), outputBuffer);
   }

   public boolean Read(long[] starts, long[] counts, int[] outputBuffer) {
       return Read(starts, counts, defaultSteps(counts.length), outputBuffer);
   }

   public boolean Read(long[] starts, long[] counts, long[] outputBuffer) {
       return Read(starts, counts, defaultSteps(counts.length), outputBuffer);
   }

   public boolean Read(long[] starts, long[] counts, float[] outputBuffer) {
       return Read(starts, counts, defaultSteps(counts.length), outputBuffer);
   }

   public boolean Read(long[] starts, long[] counts, double[] outputBuffer) {
       return Read(starts, counts, defaultSteps(counts.length), outputBuffer);
   }

   public boolean Write(long[] starts, long[] counts, long[] steps, byte[] inputBuffer) {
       return Write(starts, counts, steps, defaultStrides(counts), inputBuffer);
   }

   public boolean Write(long[] starts, long[] counts, long[] steps, short[] inputBuffer) {
       return Write(starts, counts, steps, defaultStrides(counts), inputBuffer);
   }

   public boolean Write(long[] starts, long[] counts, long[] steps, int[] inputBuffer) {
       return Write(starts, counts, steps, defaultStrides(counts), inputBuffer);
   }

   public boolean Write(long[] starts, long[] counts, long[] steps, long[] inputBuffer) {
       return Write(starts, counts, steps, defaultStrides(counts), inputBuffer);
   }

   public boolean Write(long[] starts, long[] counts, long[] steps, float[] inputBuffer) {
       return Write(starts, counts, steps, defaultStrides(counts), inputBuffer);
   }

   public boolean Write(long[] starts, long[] counts, long[] steps, double[] inputBuffer) {
       return Write(starts, counts, steps, defaultStrides(counts), inputBuffer);
   }

   public boolean Write(long[] starts, long[] counts, byte[] inputBuffer) {
       return Write(starts, counts, defaultSteps(counts.length), inputBuffer);
   }

   public boolean Write(long[] starts, long[] counts, short[] inputBuffer) {
       return Write(starts, counts, defaultSteps(counts.length), inputBuffer);
   }

   public boolean Write(long[] starts, long[] counts, int[] inputBuffer) {
       return Write(starts, counts, defaultSteps(counts.length), inputBuffer);
   }

   public boolean Write(long[] starts, long[] counts, long[] inputBuffer) {
       return Write(starts, counts, defaultSteps(counts.length), inputBuffer);
   }

   public boolean Write(long[] starts, long[] counts, float[] inputBuffer) {
       return Write(starts, counts, defaultSteps(counts.length), inputBuffer);
   }

   public boolean Write(long[] starts, long[] counts, double[] inputBuffer) {
       return Write(starts, counts, defaultSteps(counts.length), inputBuffer);
   }

  public String GetName() {
    return gdalJNI.MDArray_GetName(swigCPtr, this);
  }

  public String GetFullName() {
    return gdalJNI.MDArray_GetFullName(swigCPtr, this);
  }

  public long GetTotalElementsCount() {
  return gdalJNI.MDArray_GetTotalElementsCount(swigCPtr, this);
}

  public long GetDimensionCount() {
    return gdalJNI.MDArray_GetDimensionCount(swigCPtr, this);
  }

  public ExtendedDataType GetDataType() {
    long cPtr = gdalJNI.MDArray_GetDataType(swigCPtr, this);
    return (cPtr == 0) ? null : new ExtendedDataType(cPtr, true);
  }

  public java.util.Hashtable GetStructuralInfo() {
    return gdalJNI.MDArray_GetStructuralInfo(swigCPtr, this);
  }

  public int Resize(long[] newDimensions, java.util.Vector options) {
    return gdalJNI.MDArray_Resize__SWIG_0(swigCPtr, this, newDimensions, options);
  }

  public int Resize(long[] newDimensions) {
    return gdalJNI.MDArray_Resize__SWIG_1(swigCPtr, this, newDimensions);
  }

  public Attribute GetAttribute(String name) {
    long cPtr = gdalJNI.MDArray_GetAttribute(swigCPtr, this, name);
    return (cPtr == 0) ? null : new Attribute(cPtr, true);
  }

  public Attribute CreateAttribute(String name, long[] dimensions, ExtendedDataType data_type, java.util.Vector options) {
    long cPtr = gdalJNI.MDArray_CreateAttribute__SWIG_0(swigCPtr, this, name, dimensions, ExtendedDataType.getCPtr(data_type), data_type, options);
    return (cPtr == 0) ? null : new Attribute(cPtr, true);
  }

  public Attribute CreateAttribute(String name, long[] dimensions, ExtendedDataType data_type) {
    long cPtr = gdalJNI.MDArray_CreateAttribute__SWIG_1(swigCPtr, this, name, dimensions, ExtendedDataType.getCPtr(data_type), data_type);
    return (cPtr == 0) ? null : new Attribute(cPtr, true);
  }

  public int DeleteAttribute(String name, java.util.Vector options) {
    return gdalJNI.MDArray_DeleteAttribute__SWIG_0(swigCPtr, this, name, options);
  }

  public int DeleteAttribute(String name) {
    return gdalJNI.MDArray_DeleteAttribute__SWIG_1(swigCPtr, this, name);
  }

  public void GetNoDataValueAsDouble(Double[] val) {
    gdalJNI.MDArray_GetNoDataValueAsDouble(swigCPtr, this, val);
  }

  public String GetNoDataValueAsString() {
    return gdalJNI.MDArray_GetNoDataValueAsString(swigCPtr, this);
  }

  public int SetNoDataValueDouble(double d) {
    return gdalJNI.MDArray_SetNoDataValueDouble(swigCPtr, this, d);
  }

  public int SetNoDataValueString(String nodata) {
    return gdalJNI.MDArray_SetNoDataValueString(swigCPtr, this, nodata);
  }

  public int DeleteNoDataValue() {
    return gdalJNI.MDArray_DeleteNoDataValue(swigCPtr, this);
  }

  public void GetOffset(Double[] val) {
    gdalJNI.MDArray_GetOffset(swigCPtr, this, val);
  }

  public int GetOffsetStorageType() {
    return gdalJNI.MDArray_GetOffsetStorageType(swigCPtr, this);
  }

  public void GetScale(Double[] val) {
    gdalJNI.MDArray_GetScale(swigCPtr, this, val);
  }

  public int GetScaleStorageType() {
    return gdalJNI.MDArray_GetScaleStorageType(swigCPtr, this);
  }

  public int SetOffset(double val, int storageType) {
    return gdalJNI.MDArray_SetOffset__SWIG_0(swigCPtr, this, val, storageType);
  }

  public int SetOffset(double val) {
    return gdalJNI.MDArray_SetOffset__SWIG_1(swigCPtr, this, val);
  }

  public int SetScale(double val, int storageType) {
    return gdalJNI.MDArray_SetScale__SWIG_0(swigCPtr, this, val, storageType);
  }

  public int SetScale(double val) {
    return gdalJNI.MDArray_SetScale__SWIG_1(swigCPtr, this, val);
  }

  public int SetUnit(String unit) {
    return gdalJNI.MDArray_SetUnit(swigCPtr, this, unit);
  }

  public String GetUnit() {
    return gdalJNI.MDArray_GetUnit(swigCPtr, this);
  }

  public int SetSpatialRef(SpatialReference srs) {
    return gdalJNI.MDArray_SetSpatialRef(swigCPtr, this, SpatialReference.getCPtr(srs), srs);
  }

  public SpatialReference GetSpatialRef() {
    long cPtr = gdalJNI.MDArray_GetSpatialRef(swigCPtr, this);
    return (cPtr == 0) ? null : new SpatialReference(cPtr, true);
  }

  public MDArray GetView(String viewExpr) {
    long cPtr = gdalJNI.MDArray_GetView(swigCPtr, this, viewExpr);
    return (cPtr == 0) ? null : new MDArray(cPtr, true);
  }

  public MDArray Transpose(int[] axisMap) {
    long cPtr = gdalJNI.MDArray_Transpose(swigCPtr, this, axisMap);
    return (cPtr == 0) ? null : new MDArray(cPtr, true);
  }

  public MDArray GetUnscaled() {
    long cPtr = gdalJNI.MDArray_GetUnscaled(swigCPtr, this);
    return (cPtr == 0) ? null : new MDArray(cPtr, true);
  }

  public MDArray GetMask(java.util.Vector options) {
    long cPtr = gdalJNI.MDArray_GetMask__SWIG_0(swigCPtr, this, options);
    return (cPtr == 0) ? null : new MDArray(cPtr, true);
  }

  public MDArray GetMask() {
    long cPtr = gdalJNI.MDArray_GetMask__SWIG_1(swigCPtr, this);
    return (cPtr == 0) ? null : new MDArray(cPtr, true);
  }

  public MDArray GetGridded(String pszGridOptions, MDArray xArray, MDArray yArray, java.util.Vector options) {
    long cPtr = gdalJNI.MDArray_GetGridded__SWIG_0(swigCPtr, this, pszGridOptions, MDArray.getCPtr(xArray), xArray, MDArray.getCPtr(yArray), yArray, options);
    return (cPtr == 0) ? null : new MDArray(cPtr, true);
  }

  public MDArray GetGridded(String pszGridOptions, MDArray xArray, MDArray yArray) {
    long cPtr = gdalJNI.MDArray_GetGridded__SWIG_1(swigCPtr, this, pszGridOptions, MDArray.getCPtr(xArray), xArray, MDArray.getCPtr(yArray), yArray);
    return (cPtr == 0) ? null : new MDArray(cPtr, true);
  }

  public MDArray GetGridded(String pszGridOptions, MDArray xArray) {
    long cPtr = gdalJNI.MDArray_GetGridded__SWIG_2(swigCPtr, this, pszGridOptions, MDArray.getCPtr(xArray), xArray);
    return (cPtr == 0) ? null : new MDArray(cPtr, true);
  }

  public MDArray GetGridded(String pszGridOptions) {
    long cPtr = gdalJNI.MDArray_GetGridded__SWIG_3(swigCPtr, this, pszGridOptions);
    return (cPtr == 0) ? null : new MDArray(cPtr, true);
  }

  public Dataset AsClassicDataset(long iXDim, long iYDim, Group hRootGroup, java.util.Vector options) {
    long cPtr = gdalJNI.MDArray_AsClassicDataset__SWIG_0(swigCPtr, this, iXDim, iYDim, Group.getCPtr(hRootGroup), hRootGroup, options);
    return (cPtr == 0) ? null : new Dataset(cPtr, true);
  }

  public Dataset AsClassicDataset(long iXDim, long iYDim, Group hRootGroup) {
    long cPtr = gdalJNI.MDArray_AsClassicDataset__SWIG_1(swigCPtr, this, iXDim, iYDim, Group.getCPtr(hRootGroup), hRootGroup);
    return (cPtr == 0) ? null : new Dataset(cPtr, true);
  }

  public Dataset AsClassicDataset(long iXDim, long iYDim) {
    long cPtr = gdalJNI.MDArray_AsClassicDataset__SWIG_2(swigCPtr, this, iXDim, iYDim);
    return (cPtr == 0) ? null : new Dataset(cPtr, true);
  }

  public Statistics GetStatistics(boolean approx_ok, boolean force, ProgressCallback callback) {
    long cPtr = gdalJNI.MDArray_GetStatistics__SWIG_0(swigCPtr, this, approx_ok, force, callback);
    return (cPtr == 0) ? null : new Statistics(cPtr, false);
  }

  public Statistics GetStatistics(boolean approx_ok, boolean force) {
    long cPtr = gdalJNI.MDArray_GetStatistics__SWIG_2(swigCPtr, this, approx_ok, force);
    return (cPtr == 0) ? null : new Statistics(cPtr, false);
  }

  public Statistics GetStatistics(boolean approx_ok) {
    long cPtr = gdalJNI.MDArray_GetStatistics__SWIG_3(swigCPtr, this, approx_ok);
    return (cPtr == 0) ? null : new Statistics(cPtr, false);
  }

  public Statistics GetStatistics() {
    long cPtr = gdalJNI.MDArray_GetStatistics__SWIG_4(swigCPtr, this);
    return (cPtr == 0) ? null : new Statistics(cPtr, false);
  }

  public Statistics ComputeStatistics(boolean approx_ok, ProgressCallback callback, java.util.Vector options) {
    long cPtr = gdalJNI.MDArray_ComputeStatistics__SWIG_0(swigCPtr, this, approx_ok, callback, options);
    return (cPtr == 0) ? null : new Statistics(cPtr, false);
  }

  public Statistics ComputeStatistics(boolean approx_ok, ProgressCallback callback) {
    long cPtr = gdalJNI.MDArray_ComputeStatistics__SWIG_1(swigCPtr, this, approx_ok, callback);
    return (cPtr == 0) ? null : new Statistics(cPtr, false);
  }

  public Statistics ComputeStatistics(boolean approx_ok) {
    long cPtr = gdalJNI.MDArray_ComputeStatistics__SWIG_3(swigCPtr, this, approx_ok);
    return (cPtr == 0) ? null : new Statistics(cPtr, false);
  }

  public Statistics ComputeStatistics() {
    long cPtr = gdalJNI.MDArray_ComputeStatistics__SWIG_4(swigCPtr, this);
    return (cPtr == 0) ? null : new Statistics(cPtr, false);
  }

  public boolean Cache(java.util.Vector options) {
    return gdalJNI.MDArray_Cache__SWIG_0(swigCPtr, this, options);
  }

  public boolean Cache() {
    return gdalJNI.MDArray_Cache__SWIG_1(swigCPtr, this);
  }

  public int Rename(String newName) {
    return gdalJNI.MDArray_Rename(swigCPtr, this, newName);
  }

  public Dimension GetDimension(long index) {
    long cPtr = gdalJNI.MDArray_GetDimension(swigCPtr, this, index);
    return (cPtr == 0) ? null : new Dimension(cPtr, true);
  }

  public boolean Read(long[] starts, long[] counts, long[] steps, long[] strides, byte[] arrayOut) {
    return gdalJNI.MDArray_Read__SWIG_0(swigCPtr, this, starts, counts, steps, strides, arrayOut);
  }

  public boolean Read(long[] starts, long[] counts, long[] steps, long[] strides, short[] arrayOut) {
    return gdalJNI.MDArray_Read__SWIG_1(swigCPtr, this, starts, counts, steps, strides, arrayOut);
  }

  public boolean Read(long[] starts, long[] counts, long[] steps, long[] strides, int[] arrayOut) {
    return gdalJNI.MDArray_Read__SWIG_2(swigCPtr, this, starts, counts, steps, strides, arrayOut);
  }

  public boolean Read(long[] starts, long[] counts, long[] steps, long[] strides, long[] arrayOut) {
    return gdalJNI.MDArray_Read__SWIG_3(swigCPtr, this, starts, counts, steps, strides, arrayOut);
  }

  public boolean Read(long[] starts, long[] counts, long[] steps, long[] strides, float[] arrayOut) {
    return gdalJNI.MDArray_Read__SWIG_4(swigCPtr, this, starts, counts, steps, strides, arrayOut);
  }

  public boolean Read(long[] starts, long[] counts, long[] steps, long[] strides, double[] arrayOut) {
    return gdalJNI.MDArray_Read__SWIG_5(swigCPtr, this, starts, counts, steps, strides, arrayOut);
  }

  public boolean Write(long[] starts, long[] counts, long[] steps, long[] strides, byte[] arrayIn) {
    return gdalJNI.MDArray_Write__SWIG_0(swigCPtr, this, starts, counts, steps, strides, arrayIn);
  }

  public boolean Write(long[] starts, long[] counts, long[] steps, long[] strides, short[] arrayIn) {
    return gdalJNI.MDArray_Write__SWIG_1(swigCPtr, this, starts, counts, steps, strides, arrayIn);
  }

  public boolean Write(long[] starts, long[] counts, long[] steps, long[] strides, int[] arrayIn) {
    return gdalJNI.MDArray_Write__SWIG_2(swigCPtr, this, starts, counts, steps, strides, arrayIn);
  }

  public boolean Write(long[] starts, long[] counts, long[] steps, long[] strides, long[] arrayIn) {
    return gdalJNI.MDArray_Write__SWIG_3(swigCPtr, this, starts, counts, steps, strides, arrayIn);
  }

  public boolean Write(long[] starts, long[] counts, long[] steps, long[] strides, float[] arrayIn) {
    return gdalJNI.MDArray_Write__SWIG_4(swigCPtr, this, starts, counts, steps, strides, arrayIn);
  }

  public boolean Write(long[] starts, long[] counts, long[] steps, long[] strides, double[] arrayIn) {
    return gdalJNI.MDArray_Write__SWIG_5(swigCPtr, this, starts, counts, steps, strides, arrayIn);
  }

}
