# Author: Jeff McKenna, GatewayGeo, info@gatewaygeomatics.com

# Execute this file through Windows PowerShell before running the MapServer, 
# GDAL, PROJ, and other commandline utilities.
#
# After executing this file you should be able 
# to run the utilities from any commandline location.

$Env:PATH = "\ms4w\Apache\cgi-bin;\ms4w\tools\gdal-ogr;\ms4w\tools\mapserv;`
\ms4w\tools\shapelib;\ms4w\tools\proj;\ms4w\tools\shp2tile;\ms4w\tools\shpdiff;`
\ms4w\tools\avce00;\ms4w\gdalbindings\python\gdal;\ms4w\tools\php;\ms4w\tools\mapcache;`
\ms4w\tools\berkeley-db;\ms4w\tools\sqlite;\ms4w\tools\spatialite;\ms4w\tools\unixutils;`
\ms4w\tools\openssl;\ms4w\tools\curl;\ms4w\tools\geotiff;\ms4w\tools\jpeg;\ms4w\tools\protobuf;`
\ms4w\Python;\ms4w\Python\Scripts;\ms4w\tools\osm2pgsql;\ms4w\tools\netcdf;\ms4w\tools\pdal;`
\ms4w\tools\libtiff;\ms4w\tools\pdf;\ms4w\tools\deflate;\ms4w\tools\webp;`
\ms4w\tools\geos;\ms4w\tools\zstd;\ms4w\tools\lz4;\ms4w\tools\uriparser;`
\ms4w\tools\qhull;\ms4w\tools\libxml2;\ms4w\tools\ogdi;\ms4w\tools\brotli;`
\ms4w\tools\jansson;\ms4w\tools\harfbuzz;" + $Env:PATH
$Env:USE_PATH_FOR_GDAL_PYTHON = "YES"
$Env:PYTHONHOME = "\ms4w\Python"
$Env:PYTHONPATH = "\ms4w\Apache\cgi-bin;\ms4w\Python\DLLs;\ms4w\Python\Lib;\ms4w\Python\Lib\site-packages;\ms4w\Python;\ms4w\Python\Lib\site-packages\osgeo_utils;%PYTHONPATH%"
$Env:PYTHONUTF8 = "1"
$Env:GDAL_DATA = "\ms4w\gdaldata"
$Env:GDAL_DRIVER_PATH = "\ms4w\gdalplugins"
$Env:GDAL_FILENAME_IS_UTF8 = "1"
$Env:VSI_CACHE = "TRUE"
$Env:VSI_CACHE_SIZE = "1000000"
$Env:PROJ_DATA = "\ms4w\share\proj"
$Env:PROJ_USER_WRITABLE_DIRECTORY = "\ms4w\share\proj"
$Env:CURL_CA_BUNDLE = "\ms4w\Apache\conf\ca-bundle\cacert.pem"
$Env:SSL_CERT_FILE = "\ms4w\Apache\conf\ca-bundle\cacert.pem"
$Env:OPENSSL_CONF = "\ms4w\tools\openssl\openssl.cnf"
$Env:PDAL_DRIVER_PATH = "\ms4w\Apache\cgi-bin"
$Env:MAPSERVER_CONFIG_FILE = "\ms4w\ms4w.conf"

Write-Output "mapserv, GDAL, Python, PHP, PROJ, and commandline MS4W tools path set"
Write-Output "happy MapServ-ing!"