'''
 Purpose:       Test mod_wsgi with Python MapScript
 Instructions:  - modify: - the MAPFILE path on line 44
                - open Command Prompt window and :
                     cd /ms4w
                     setenv.bat
                     cd /ms4w/msplugins/mapscript/python
                     python test-wsgi-mapscript.py
                - you should see a message as:
                     Serving on port 8001...
                - open a browser and goto: 
                     http://localhost:8001/?service=WMS&version=1.3.0&request=GetCapabilities
                - a WMS GetCapabilities response should be displayed in your browser
 Authors:       - Tom Kralidis
                - Jeff McKenna, GatewayGeo, info@gatewaygeomatics.com
 Last updated:  2024-08-14
'''

import os
import sys

import mapscript


# List of all environment variable used by MapServer
MAPSERV_ENV = [
  'CONTENT_LENGTH', 'CONTENT_TYPE', 'CURL_CA_BUNDLE', 'HTTP_COOKIE',
  'HTTP_HOST', 'HTTPS', 'HTTP_X_FORWARDED_HOST', 'HTTP_X_FORWARDED_PORT',
  'HTTP_X_FORWARDED_PROTO', 'MS_DEBUGLEVEL', 'MS_ENCRYPTION_KEY',
  'MS_ERRORFILE', 'MS_MAPFILE', 'MS_MAPFILE_PATTERN', 'MS_MAP_NO_PATH',
  'MS_MAP_PATTERN', 'MS_MODE', 'MS_OPENLAYERS_JS_URL', 'MS_TEMPPATH',
  'MS_XMLMAPFILE_XSLT', 'PROJ_LIB', 'QUERY_STRING', 'REMOTE_ADDR',
  'REQUEST_METHOD', 'SCRIPT_NAME', 'SERVER_NAME', 'SERVER_PORT'
]


def application(env, start_response):
    for key in MAPSERV_ENV:
        if key in env:
            os.environ[key] = env[key]
        else:
            os.unsetenv(key)

    mapfile = 'C:/ms4w/apps/local-demo/local.map'
    mapfile = mapscript.mapObj(mapfile)

    request = mapscript.OWSRequest()
    mapscript.msIO_installStdoutToBuffer()
    request.loadParamsFromURL(env['QUERY_STRING'])

    try:
        status = mapfile.OWSDispatch(request)
    except Exception as err:
        pass

    content_type = mapscript.msIO_stripStdoutBufferContentType()
    result = mapscript.msIO_getStdoutBufferBytes()
    start_response('200 OK', [('Content-type', content_type)])
    return [result]

if __name__ == '__main__':  # run inline using WSGI reference implementation
    from wsgiref.simple_server import make_server
    port = 8001
    if len(sys.argv) > 1:
        port = int(sys.argv[1])
    httpd = make_server('', port, application)
    print('Serving on port %d...' % port)
    httpd.serve_forever()