<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- English Revision: 420990:421100 (outdated) -->
<!-- French translation : Lucien GENTIS -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="stopping.xml.meta">

  <title>Arr&ecirc;t et red&eacute;marrage</title>

<summary>
    <p>Ce document couvre l'arr&ecirc;t et le red&eacute;marrage d'Apache sur
    les syst&egrave;mes Unix et similaires. Les utilisateurs de Windows NT, 2000
    and XP doivent consulter
    <a href="platform/windows.html#winsvc">Ex&eacute;cuter Apache en tant que
    service</a> et les utilisateurs de Windows 9x et ME doivent consulter
    <a href="platform/windows.html#wincons">Ex&eacute;cuter Apache comme une
    application de type console</a> pour plus d'informations sur le contr&ocirc;le
    d'Apache &agrave; partir de ces plateformes.</p>
</summary>

<seealso><program>httpd</program></seealso>
<seealso><program>apachectl</program></seealso>
<seealso><a href="invoking.html">D&eacute;marrage</a></seealso>

<section id="introduction"><title>Introduction</title>

    <p>Afin d'arr&ecirc;ter ou red&eacute;marrer Apache, vous devez envoyer un signal aux
    processus <program>httpd</program> en cours d'ex&eacute;cution.  Les signaux
    peuvent &ecirc;tre envoy&eacute;s de deux mani&egrave;res.  Tout d'abord, vous pouvez
    utiliser la commande unix <code>kill</code>
    pour envoyer directement des signaux aux processus. Vous pouvez remarquer
    que plusieurs processus <program>httpd</program> s'ex&eacute;cutent sur votre
    syst&egrave;me, mais il vous suffit d'envoyer les signaux au processus parent,
    dont le PID est enregistr&eacute; dans le fichier pr&eacute;cis&eacute; par la directive
    <directive module="mpm_common">PidFile</directive>. C'est &agrave; dire que vous
    n'aurez jamais besoin d'envoyer des signaux &agrave; aucun de ces processus,
    sauf au processus parent. Trois types de signaux peuvent &ecirc;tre envoy&eacute;s
    au processus parent :
    <code><a href="#term">TERM</a></code>,
    <code><a href="#graceful">USR1</a></code>,
    <code><a href="#hup">HUP</a></code>, et
    <code><a href="#gracefulstop">WINCH</a></code>, qui
    sera d&eacute;crit plus loin.</p>

    <p>Pour envoyer un signal au processus parent, vous devez entrer une commande
    du style :</p>

<example>kill -TERM `cat /usr/local/apache2/logs/httpd.pid`</example>

    <p>La seconde m&eacute;thode permettant d'envoyer des signaux aux processus
    <program>httpd</program>
    consiste &agrave; utiliser les options de ligne de commande <code>-k</code> :
    <code>stop</code>,
    <code>restart</code>, <code>graceful</code> et <code>graceful-stop</code>,
    comme d&eacute;crit ci-dessous.  Ce sont des arguments du binaire
    <program> httpd</program>, mais il est recommand&eacute; de les utiliser
    avec le script de contr&ocirc;le <program>apachectl</program>, qui se
    chargera de les passer &agrave; <program>httpd</program>.</p>

    <p>Apr&egrave;s avoir envoy&eacute; un signal &agrave; <program>httpd</program>, vous pouvez
    suivre le cours de son action en entrant :</p>

<example>tail -f /usr/local/apache2/logs/error_log</example>

    <p>Adaptez ces exemples en fonction de la d&eacute;finition de vos directives
    <directive module="core">ServerRoot</directive> et
    <directive module="mpm_common">PidFile</directive>.</p>
</section>

<section id="term"><title>Arr&ecirc;ter imm&eacute;diatement</title>

<dl><dt>Signal: TERM</dt>
<dd><code>apachectl -k stop</code></dd>
</dl>

    <p>L'envoi du signal <code>TERM</code> ou <code>stop</code> au
    processus parent induit chez celui-ci une tentative imm&eacute;diate
    de tuer tous ses processus enfants. Cela peut durer plusieurs secondes.
    Apr&egrave;s cela, le processus parent lui-m&ecirc;me se termine. Toutes les requ&ecirc;tes
    en cours sont termin&eacute;es, et plus aucune autre n'est trait&eacute;e.</p>
</section>

<section id="graceful"><title>Red&eacute;marrage en douceur</title>

<dl><dt>Signal: USR1</dt>
<dd><code>apachectl -k graceful</code></dd>
</dl>

    <p>L'envoi du signal <code>USR1</code> ou <code>graceful</code> au
    processus parent lui fait envoyer aux processus enfants
    <em>l'ordre</em> de se terminer une fois leur requ&ecirc;te courante
    trait&eacute;e (ou de se terminer imm&eacute;diatement s'ils n'ont plus rien &agrave; traiter).
    Le processus parent relit ses fichiers de configuration et
    r&eacute;ouvre ses fichiers de log. Chaque fois qu'un enfant s'&eacute;teint, le
    processus parent le remplace par un processus
    enfant de la nouvelle <em>g&eacute;n&eacute;ration</em> de la
    configuration, et celui-ci commence imm&eacute;diatement &agrave; traiter les
    nouvelles requ&ecirc;tes.</p>

    <p>Ce code est con&ccedil;u pour toujours respecter la directive de contr&ocirc;le
    de processus des modules MPMs, afin que les nombres de processus et de
    threads
    disponibles pour traiter les demandes des clients soient maintenus &agrave;
    des valeurs appropri&eacute;es tout au long du processus de d&eacute;marrage.
    En outre, il respecte la directive
    <directive module="mpm_common">StartServers</directive> de la mani&egrave;re
    suivante : si apr&egrave;s une seconde au moins <directive
    module="mpm_common">StartServers</directive> nouveaux processus
    enfants n'ont pas &eacute;t&eacute; cr&eacute;&eacute;s, un nombre suffisant de processus
    suppl&eacute;mentaires est cr&eacute;&eacute; pour combler le manque. Ainsi le code
    tente de maintenir &agrave; la fois le nombre appropri&eacute; de processus enfants
    en fonction de la charge du serveur, et vos souhaits d&eacute;finis par la
    directive <directive module="mpm_common">StartServers</directive>.</p>

    <p>Les utilisateurs du module <module>mod_status</module>
    noteront que les statistiques du serveur ne sont <strong>pas</strong>
    remises &agrave; z&eacute;ro quand un signal <code>USR1</code> est envoy&eacute;. Le code
    a &eacute;t&eacute; con&ccedil;u &agrave; la fois pour minimiser la dur&eacute;e durant laquelle le
    serveur ne peut pas traiter de nouvelles requ&ecirc;tes (elle sont mises en
    file d'attente par le syst&egrave;me d'exploitation, et ne sont ainsi jamais
    perdues) et pour respecter vos param&egrave;tres de personnalisation.
    Afin d'accomplir ceci, il doit conserver le
    <em>tableau</em> utilis&eacute; pour garder la trace de tous les processus
    enfants au cours des diff&eacute;rentes g&eacute;n&eacute;rations.</p>

    <p>Le module status utilise aussi un <code>G</code> afin d'indiquer
    quels processus enfants ont encore des traitements de requ&ecirc;tes en cours
    d&eacute;but&eacute;s avant que l'ordre graceful restart ne soit donn&eacute;.</p>

    <p>Pour l'instant, il est impossible pour un script de rotation
    des logs utilisant
    <code>USR1</code> de savoir de mani&egrave;re certaine si tous les processus
    enfants inscrivant des traces de pr&eacute;-red&eacute;marrage sont termin&eacute;s.
    Nous vous sugg&eacute;rons d'attendre un d&eacute;lai suffisant apr&egrave;s l'envoi du
    signal <code>USR1</code>
    avant de faire quoi que ce soit avec les anciens logs. Par exemple,
    si la plupart de vos traitements durent moins de 10 minutes pour des
    utilisateurs empruntant des liaisons &agrave; faible bande passante, alors vous
    devriez attendre 15 minutes avant de faire quoi que ce soit
    avec les anciens logs.</p>

    <note>
    Si votre fichier de configuration comporte des erreurs lorsque vous
    effectuez un red&eacute;marrage, votre processus parent ne red&eacute;marrera pas
    et se terminera avec une erreur. Dans le cas d'un red&eacute;marrage en douceur
    (graceful restart), il laissera les processus enfants
    s'ex&eacute;cuter quand il s'arr&ecirc;tera. (Ce sont les processus enfants qui
    "s'arr&ecirc;tent en douceur" en terminant de traiter leur derni&egrave;re requ&ecirc;te.)
    Ceci provoquera des probl&egrave;mes si vous tentez de red&eacute;marrer le serveur
    -- il ne pourra pas s'associer &agrave; ses ports d'&eacute;coute. Avant d'effectuer un
    red&eacute;marrage, vous pouvez v&eacute;rifier la syntaxe des fichiers de
    configuration &agrave; l'aide de l'argument de ligne de commande <code>-t</code>
    (voir <program>httpd</program>).

    Ceci ne garantit pas encore que le serveur va red&eacute;marrer
    correctement. Pour v&eacute;rifier la s&eacute;mantique des fichiers de configuration
    en plus de leur syntaxe, vous pouvez essayer de d&eacute;marrer
    <program>httpd</program> sous un utilisateur non root.
    S'il n'y a pas d'erreurs, il tentera d'ouvrir ses sockets et ses fichiers
    de log et &eacute;chouera car il n'a pas les privil&egrave;ges root (ou parce que
    l'instance actuelle de
    <program>httpd</program> est d&eacute;j&agrave; associ&eacute;e &agrave; ces ports). S'il &eacute;choue
    pour toute autre raison, il y a probablement une erreur dans le
    fichier de configuration et celle-ci doit &ecirc;tre corrig&eacute;e avant de lancer
    le red&eacute;marrage en douceur.</note>
</section>

<section id="hup"><title>Red&eacute;marrer imm&eacute;diatement</title>

<dl><dt>Signal: HUP</dt>
<dd><code>apachectl -k restart</code></dd>
</dl>

    <p>L'envoi du signal <code>HUP</code> ou <code>restart</code> au
    processus parent lui fait tuer ses processus enfants comme pour le signal
    <code>TERM</code>, mais le processus parent ne se termine pas.
    Il relit ses fichiers de configuration, et r&eacute;ouvre ses fichiers de log.
    Puis il donne naissance &agrave; un nouveau jeu de processus enfants
    et continue de traiter les requ&ecirc;tes.</p>

    <p>Les utilisateurs du module <module>mod_status</module>
    noteront que les statistiques du serveur sont remises &agrave; z&eacute;ro quand un
    signal <code>HUP</code> est envoy&eacute;.</p>

<note>Si votre fichier de configuration comporte des erreurs quand vous
effectuez un red&eacute;marrage, votre processus parent ne red&eacute;marrera pas,
il se terminera avec une erreur. Voir plus haut la m&eacute;thode &agrave; employer
pour &eacute;viter ce probl&egrave;me.</note>
</section>

<section id="gracefulstop"><title>Arr&ecirc;t en douceur</title>

<dl><dt>Signal : WINCH</dt>
<dd><code>apachectl -k graceful-stop</code></dd>
</dl>

    <p>L'envoi du signal <code>WINCH</code> ou <code>graceful-stop</code>
    au processus parent lui fait <em>aviser</em> les processus enfants
    de s'arr&ecirc;ter apr&egrave;s le traitement de leur requ&ecirc;te en cours
    (ou de s'arr&ecirc;ter imm&eacute;diatement s'ils n'ont plus de requ&ecirc;te &agrave; traiter).
    Le processus parent va alors supprimer son fichier
    <directive  module="mpm_common">PidFile</directive> et cesser l'&eacute;coute
    de tous ses ports. Le processus parent va continuer &agrave; s'ex&eacute;cuter,
    et va surveiller les processus enfants
    qui ont encore des requ&ecirc;tes &agrave; traiter. Lorsque tous les processus enfants
    ont termin&eacute; leurs traitements et se sont arr&ecirc;t&eacute;s ou lorsque le d&eacute;lai
    sp&eacute;cifi&eacute; par la directive <directive
    module="mpm_common">GracefulShutdownTimeout</directive> a &eacute;t&eacute; atteint,
    le processus parent s'arr&ecirc;tera &agrave; son tour.  Si ce d&eacute;lai est atteint,
    tout processus enfant encore en cours d'ex&eacute;cution se verra envoyer
    le signal <code>TERM</code>
    afin de le forcer &agrave; s'arr&ecirc;ter.</p>

    <p>L'envoi du signal <code>TERM</code> va arr&ecirc;ter imm&eacute;diatement
    les processus parent et enfants en &eacute;tat "graceful". Cependant,
    comme le fichier <directive module="mpm_common">PidFile</directive>
    aura &eacute;t&eacute; supprim&eacute;, vous ne pourrez pas utiliser
    <code>apachectl</code> ou <code>httpd</code> pour envoyer ce signal.</p>

    <note><p>Le signal <code>graceful-stop</code> vous permet d'ex&eacute;cuter
    simultan&eacute;ment plusieurs instances de <program>httpd</program>
    avec des configurations identiques. Ceci s'av&egrave;re une fonctionnalit&eacute;
    puissante quand vous effectuez des mises &agrave; jour "en douceur" d'Apache;
    cependant, cela peut aussi causer des blocages fatals et des
    situations de comp&eacute;tition (race conditions)
    avec certaines configurations.</p>

    <p>On a pris soin de s'assurer que les fichiers sur disque
    comme ceux d&eacute;finis par les directives
    <directive module="core">Lockfile</directive> et
    <directive  module="mod_cgid">ScriptSock</directive> contiennent le PID
    du serveur dans leurs noms donc ils coexistent sans probl&egrave;me.
    Cependant, si une directive de
    configuration , un module tiers ou une CGI r&eacute;sidente utilise un autre
    verrou ou fichier d'&eacute;tat sur disque, il faut prendre soin de s'assurer
    que chaque instance de <program>httpd</program> qui s'ex&eacute;cute
    n'&eacute;crase pas les fichiers des autres instances.</p>

    <p>Vous devez aussi prendre garde aux autres situations de comp&eacute;tition,
    comme l'utilisation de l'enregistrement des logs avec un transfert de ceux-ci
    dans le style <program>rotation des logs</program>. Plusieurs instances
    du programme de <program>rotation des logs</program> qui tentent d'effectuer
    une rotation des m&ecirc;mes fichiers de log en m&ecirc;me temps peuvent d&eacute;truire
    mutuellement leurs propres fichiers de log.</p></note>
</section>

</manualpage>
