<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="es" xml:lang="es"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Soporte de Objetos Dinamicos Compartidos (DSO) - Servidor HTTP Apache</title>
<link href="./style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="./style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="./style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="./images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="./mod/">Mdulos</a> | <a href="./mod/directives.html">Directivas</a> | <a href="./faq/">Preguntas Frecuentes</a> | <a href="./glossary.html">Glosario</a> | <a href="./sitemap.html">Mapa de este sitio web</a></p>
<p class="apache">Versin 2.0 del Servidor HTTP Apache</p>
<img alt="" src="./images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="./images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Servidor HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentacin</a> &gt; <a href="./">Versin 2.0</a></div><div id="page-content"><div id="preamble"><h1>Soporte de Objetos Dinamicos Compartidos (DSO)</h1>
<div class="toplang">
<p><span>Idiomas disponibles: </span><a href="./en/dso.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./es/dso.html" title="Espaol">&nbsp;es&nbsp;</a> |
<a href="./fr/dso.html" hreflang="fr" rel="alternate" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/dso.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/dso.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div>

    <p>El servidor HTTP Apache es un programa modular en el que el
    administrador puede elegir qu funcionalidades se incluyen
    mediante la seleccin de un conjunto de mdulos. En
    primer lugar, los mdulos pueden compilarse de manera
    esttica en el binario <code class="program"><a href="./programs/httpd.html">httpd</a></code>. De forma
    alternativa, los mdulos tambin pueden compilarse como
    Objetos Dinamicos Compartidos (DSOs) que existen de forma
    independiente del archivo binario <code class="program"><a href="./programs/httpd.html">httpd</a></code>. Los
    mdulos que se deseen usar como objetos dinmicos
    compartidos pueden compilarse al mismo tiempo que el servidor, o
    pueden compilarse en otro momento y ser aadidos despus
    usando la Herramienta de Extensin de Apache
    (<code class="program"><a href="./programs/apxs.html">apxs</a></code>).</p>

    <p>Este documento describe cmo usar los mdulos en
    forma de objeto dinmico compartido (DSO) as como los
    fundamentos tericos que hay detrs para explicar su
    funcionamiento.</p>
  </div>
<div id="quickview"><ul id="toc"><li><img alt="" src="./images/down.gif" /> <a href="#implementation">Implementacin</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#usage">Resumen de uso</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#background">Fundamentos teorricos
detrs de los objetos dinmicos compartidos</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#advantages">Ventajas e Inconvenientes</a></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="implementation" id="implementation">Implementacin</a></h2>

<table class="related"><tr><th>Mdulos Relacionados</th><th>Directivas Relacionadas</th></tr><tr><td><ul><li><code class="module"><a href="./mod/mod_so.html">mod_so</a></code></li></ul></td><td><ul><li><code class="directive"><a href="./mod/mod_so.html#loadmodule">LoadModule</a></code></li></ul></td></tr></table>

    <p>Cargar mdulos de Apache individualmente como objetos
    dinmicos compartidos (DSO) es posible gracias a un
    mdulo llamado <code class="module"><a href="./mod/mod_so.html">mod_so</a></code> que debe compilarse
    estticamente en el ncleo (kernel) de Apache. Es el
    nico mdulo junto con el mdulo
    <code class="module"><a href="./mod/core.html">core</a></code> que no se puede usar como objeto
    dinmico compartido. Prcticamente todos los dems
    mdulos distribuidos con Apache se pueden usar como objetos
    dinmicos compartidos individualmente siempre y cuando se
    haya activado la posibilidad de usarlos con la opcin de
    <code class="program"><a href="./programs/configure.html">configure</a></code>
    <code>--enable-<em>module</em>=shared</code> tal y como se
    explic en la <a href="install.html">documentacin de
    instalacin</a>. Una vez que haya compilado un mdulo
    como objeto dinmico compartido y le haya puesto un nombre
    del tipo <code>mod_foo.so</code>, puede cargarlo al iniciar o
    reiniciar el servidor usando el comando <code class="directive"><a href="./mod/mod_so.html#loadmodule">LoadModule</a></code> de <code class="module"><a href="./mod/mod_so.html">mod_so</a></code>
    en el fichero <code>httpd.conf</code>.</p>

    <p>Para simplificar la creacin de objetos dinmicos
    compartidos para Apache (especialmente mdulos de terceras
    partes) est disponible un nuevo programa de soporte llamado
    <code class="program"><a href="./programs/apxs.html">apxs</a></code> (<em>APache eXtenSion</em>). Puede usar
    este programa para crear mdulos como objetos dinmicos
    compartidos <em>sin tener que</em> crearlos al mismo tiempo que
    compila su servidor Apache. La idea es simple: cuando se instala
    Apache el procedimiento <code>make install</code> de
    <code class="program"><a href="./programs/configure.html">configure</a></code> @@@ installs the Apache C header
    files and puts the platform-dependent compiler and linker flags
    for building DSO files into the apxs program / instala los
    ficheros de cabecera de C de Apache y especifica las opciones de
    compilacin y enlace dependientes de la plataforma para
    generar objetos dinmicos compartidos con
    <code class="program"><a href="./programs/apxs.html">apxs</a></code>. De esta manera el usuario puede usar
    <code class="program"><a href="./programs/apxs.html">apxs</a></code> para compilar el cdigo fuente de
    mdulos de Apache de manera independiente y sin tener que
    preocuparse por las opciones de compilacin y enlace
    dependientes de la plataforma que soportan objetos dinmicos
    compartidos.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="usage" id="usage">Resumen de uso</a></h2>

    <p>Para que se haga una idea de lo que permite el soporte de
    objetos dinmicos compartidos en Apache 2.0, aqu tiene
    un resumen breve pero conciso:</p>

    <ol>
      <li>
        Construir e instalar un mdulo <em>incluido en la
        distribucin</em> de Apache, digamos
        <code>mod_foo.c</code>, como un objeto dinmico
        compartido de nombre <code>mod_foo.so</code>:

<div class="example"><p><code>
$ ./configure --prefix=/path/to/install --enable-foo=shared<br />
$ make install
</code></p></div>
      </li>

      <li>
        Construir e instalar un mdulo de Apache de una
        <em>tercera parte</em>, digamos <code>mod_foo.c</code>, como
        un objeto dinmico compartido de nombre
        <code>mod_foo.so</code>:

<div class="example"><p><code>
$ ./configure --add-module=module_type:/path/to/3rdparty/mod_foo.c --enable-foo=shared<br />
$ make install
</code></p></div>
      </li>

      <li>
        Configurar Apache para poder <em>instalar despus</em>
        objetos dinmicos compartidos:

<div class="example"><p><code>
$ ./configure --enable-so<br />
$ make install
</code></p></div>
      </li>

      <li>
	Construir e instalar un mdulo de Apache de una
        <em>tercera parte</em>, digamos <code>mod_foo.c</code>, como
        un objeto dinmico compartido de nombre
        <code>mod_foo.so</code> <em>fuera</em> de la estructura de
        directorios de Apache usando <code class="program"><a href="./programs/apxs.html">apxs</a></code>:

<div class="example"><p><code>
$ cd /path/to/3rdparty<br />
$ apxs -c mod_foo.c<br />
$ apxs -i -a -n foo mod_foo.la
</code></p></div>
      </li>
    </ol>

    <p>En todos los casos, una vez que se compila el objeto
        dinmico compartido, debe usar una directiva <code class="directive"><a href="./mod/mod_so.html#loadmodule">LoadModule</a></code> en
        <code>httpd.conf</code> para activar dicho mdulo.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="background" id="background">Fundamentos teorricos
detrs de los objetos dinmicos compartidos</a></h2>

    <p>En las versiones modernas de Unix, existe un mecanismo
    especialmente til normalmente llamado enlazado/carga de
    <em>Objetos Dinmicos Compartidos</em> (DSO). Este mecanismo
    ofrece una forma de construir trozos de cdigo de programa en
    un formato especial para cargarlo en tiempo de ejecucin en
    el espacio de direcciones de memoria de un programa
    ejecutable.</p>

    <p>Esta carga puede hacerse de dos maneras: automticamente
    con un programa de sistema llamado <code>ld.so</code> al inicio de
    un programa ejecutable o manualmente desde dentro del programa en
    ejecucin con una interfaz programtica del sistema al
    cargador de Unix mediante llamadas al sistema
    <code>dlopen()/dlsym()</code>.</p>

    <p>Si se usa el primer mtodo, los objetos dinmicos
        compartidos se llaman normalmente <em>libreras
        compartidas</em>  <em>libreras DSO</em> y se
        nombran como <code>libfoo.so</code> o
        <code>libfoo.so.1.2</code>. Residen en un directorio de
        sistema (normalmente <code>/usr/lib</code>) y el enlace con el
        programa ejecutable se establece al construir la librera
        especificando la opcin<code>-lfoo</code> al comando de
        enlace. Esto incluye las referencias literales a las
        libreras en el programa ejecutable de manera que cuando
        se inicie, el cargador de Unix ser capaz de localizar
        <code>libfoo.so</code> en <code>/usr/lib</code>, en rutas
        referenciadas literalmente mediante opciones del linker como
        <code>-R</code> o en rutas configuradas mediante la variable
        de entorno <code>LD_LIBRARY_PATH</code>. Entonces se resuelven
        los smbolos (todava no resueltos) en el programa
        ejecutable que estn presentes en el objeto dinmico
        compartido.</p>

    <p>Los smbolos en el programa ejecutable no estn
    referenciados normalmente en el objeto dinmico compartido
    (porque son libreras reusables de propsito general) y
    por tanto, no se producen ms resoluciones. El programa
    ejecutable no tiene que hacer nada por s mismo para usar los
    smbolos del objeto dinmico compartido porque todo el
    trabajo de resolucin lo hace @@@ Unix loader / el cargador
    de Unix @@@. (De hecho, el cdigo para invocar
    <code>ld.so</code> es parte del cdigo que se ejecuta al
    iniciar, y que hay en cualquier programa ejecutable que haya sido
    construido de forma no esttica). La ventaja de cargar
    dinmicamente el cdigo de las libreras comunes es
    obvia: el cdigo de las libreras necesita ser almacenado
    solamente una vez, en una librera de sistema como
    <code>libc.so</code>, ahorrando as espacio en disco.</p>

    <p>Por otro lado, los objetos dinmicos compartidos
        tambin suelen llamarse <em>objetos compatidos</em> o
        <em>ficheros DSO</em> y se les puede nombrar con cualquier
        extensin (aunque su nombre cannico es
        <code>foo.so</code>). Estos archivos normalmente permanecen
        dentro de un directorio especfico del programa y no se
        establecen enlaces automticamente con los programas
        ejecutables con los que se usan.  En lugar de esto, el
        programa ejecutable carga manualmente el objeto dinmico
        compartido en tiempo de ejecucin en su espacio de
        direcciones de memoria con <code>dlopen()</code>. En ese
        momento no se resuelven los smbolos del objeto
        dinmico compartido para el programa ejecutable. En lugar
        de esto, el cargador de Unix resuelve automticamente los
        smbolos (an no resueltos en el objeto
        dinmico compartido del conjunto de smbolos
        exportados por el programa ejecutable y de las libreras
        DSO que tenga ya cargadas (especialmente todos los
        smbolos de la omnipresente <code>libc.so</code>). De
        esta manera el objeto dinmico compartido puede conocer
        el conjunto de smbolos del programa ejecutable como si
        hubiera sido enlazado estticamente en un primer
        momento.</p>

    <p>Finalmente, para beneficiarse de la API de las DSOs, el
    programa ejecutable tiene que resolver los smbolos
    particulares de la DSO con <code>dlsym()</code> para ser usado
    ms tarde dentro de tablas de direccionamiento (dispatch
    tables) <em>etc.</em> En otras palabras: El programa ejecutable
    tiene que resolver manualmente cada uno de los smbolos que
    necesita para poder usarlo despus. La ventaja de ese
    mecanismo es que las partes opcionales del programa no necesitan
    ser cargadas (y por tanto no consumen memoria) hasta que se
    necesitan por el programa en cuestin. Cuando es necesario,
    estas partes del programa pueden cargarse dinmicamente para
    expandir las funcionalidades bsicas del programa.</p>

    <p>Aunque este mecanismo DSO parece muy claro, hay al menos un
    paso de cierta dificultad: la resolucin de los smbolos
    que usa el programa ejecutable por la DSO cuando se usa una DSO
    para extender la funcionalidad de una programa (segundo caso). Por
    qu? Porque la resolucin inversa de smbolos de
    DSOs del conjunto de smbolos del programa ejecutable se hace
    en contra del diseo de la librera (donde la
    librera no tiene conocimiento sobre los programas que la
    usan) y tampoco est disponible en todas las plataformas no
    estandarizadas. En la prctica los smbolos globales del
    programa ejecutable estn disponibles para su uso en una
    DSO. El mayor problema que hay que resolver cuando se usan DSOs
    para extender un programa en tiempo de ejecucin es encontrar
    un modo de forzar al enlazador a exportar todos los smbolos
    globales.</p>

    <p>El enfoque de las libreras compartidas es bastante
    tpico, porque es para lo que se diseo el mecanismo
    DSO, por tanto se usa para casi todos los tipos de libreras
    que incluye el sistema operativo. Por otro lado, no muchos
    programas usan objetos compartidos para expandir sus
    funcionalidades.</p>

    <p>En 1998, haba solamente unos pocos programas disponibles
    que usaban el mecanismo DSO para extender su funcionalidad en
    tiempo de ejecucion: Perl 5 (por medio de su mecanismo XS y el
    mdulo DynaLoader), Netscape Server, <em>etc.</em> A partir
    de la version 1.3, Apache se uni a este grupo, Apache usa
    desde entonces una concepcin modular para extender su
    funcionalidad e internamente usa un enfoque de tablas de
    direccionamiento (dispatch-list-based) para enlazar mdulos
    externos con las funcionalidades propias del servidor. De esta
    manera, Apache puede usar el mecanismo DSO para cargar sus
    mdulos en tiempo de ejecucin.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="advantages" id="advantages">Ventajas e Inconvenientes</a></h2>

    <p>Las caractersticas de las libreras dinmicas
    compartidas arriba explicadas tienen las siguientes ventajas:</p>

    <ul>
      <li>El servidor es mucho ms flexible en tiempo de
      ejecucin porque pueden aadirse mdulos mediante
      comandos de configuracin <code class="directive"><a href="./mod/mod_so.html#loadmodule">LoadModule</a></code> en
      <code>httpd.conf</code> en lugar de tener que hacerlo con las
      opciones de <code class="program"><a href="./programs/configure.html">configure</a></code> al compilar. Por
      ejemplo, de esta manera uno puede ejecutar diferentes instancias
      del servidor (estndar &amp; SSL, mnima &amp; super
      potente [mod_perl, PHP3], <em>etc.</em>) con una nica
      instalacin de Apache.</li>

      <li>El servidor puede ser extendido fcilmente con
      mdulos de terceras partes despus de la
      instalacin. Esto es un gran beneficio al menos para los
      mantenedores de paquetes de distribuciones, que pueden crear un
      paquete bsico de Apache y paquetes adicionales que
      contengan extensiones tales como PHP3, mod_perl, mod_fastcgi,
      <em>etc.</em></li>

      <li>Facilita la labor de hacer prototipos de mdulos de
      Apache porque con el do DSO/<code class="program"><a href="./programs/apxs.html">apxs</a></code> se
      puede trabajar fuera de la estructura de directorios de Apache y
      nicamente es necesario el comando <code>apxs -i</code>
      seguido del comando <code>apachectl restart</code> para probar
      la nueva versin del mdulo que se est
      desarrollando.</li>
    </ul>

    <p>DSO presenta los siguientes inconvenientes:</p>

    <ul>
      <li>El mecanismo DSO no puede ser usado en todas las plataformas
      porque no todos los sistemas operativos soportan la carga
      dinmica de cdigo en el espacio de direcciones de
      memoria de un programa.</li>

      <li>El servidor es aproximadamente un 20% ms lento
      inicindose por la sobrecarga que implica la
      resolucin de smbolos por parte del cargador de Unix.</li>

      <li>El servidor es aproximadamente un 5% ms lento
      ejecutndose en algunas plataformas porque el cdigo
      posicionado independientemente (PIC) necesita algunas veces
      procesos bastante complicados para calcular direcciones
      relativas que no son en principio tan rpidos como los que
      se usan para calcular direcciones absolutas.</li>

      <li>Como los mdulos DSO no pueden enlazarse a otras
      libreras basadas en DSO (<code>ld -lfoo</code>) en todas
      las plataformas (por ejemplo en las plataformas basadas en a.out
      normalmente no puede ser usada esta funcionalidad, mientras que
      s puede ser usada en las plataformas basadas en ELF) no se
      puede usar el mecanismo DSO para todos los tipos de
      mdulos. En otras palabras, los mdulos compilados
      como ficheros DSO solamente pueden usar smbolos del
      ncleo (kernel) de Apache, los de las libreras de C
      (<code>libc</code>) y de todas las demas libreras
      dinmicas o estticas usadas por el ncleo de
      Apache, o de archivos de libreras estticas
      (<code>libfoo.a</code>) que contengan cdigo independiente
      de su posicin. Las nicas posibilidades para usar
      otro cdigo es asegurarse de que el ncleo de Apache
      contiene una referencia a l o cargar el cdigo por
      medio de <code>dlopen()</code>.</li>
    </ul>

</div></div>
<div class="bottomlang">
<p><span>Idiomas disponibles: </span><a href="./en/dso.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./es/dso.html" title="Espaol">&nbsp;es&nbsp;</a> |
<a href="./fr/dso.html" hreflang="fr" rel="alternate" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/dso.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/dso.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 1995-2006 The Apache Software Foundation or its licensors, as applicable.<br />Licencia bajo los trminos de la <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="./mod/">Mdulos</a> | <a href="./mod/directives.html">Directivas</a> | <a href="./faq/">Preguntas Frecuentes</a> | <a href="./glossary.html">Glosario</a> | <a href="./sitemap.html">Mapa de este sitio web</a></p></div>
</body></html>