/**
 *
 * @author Andriy Oblivantsev <eslider@gmail.com>
 * @copyright 25.08.2015 by WhereGroup GmbH & Co. KG
 * @deprecated know your own data types (objects vs arrays) and bring your own appropriate iterations
 * @todo: remove usages from Digitizer 1.1+
 * @todo: remove in v0.3.x
 */

window.DataUtil = new function() {

    var self = this;

    /**
     * Check and replace values recursive if they should be translated.
     * For checking used "translationReg" variable
     *
     *
     * @param items
     */
    function eachItem_(items, callback) {
        var isArray = items instanceof Array;
        if(isArray) {
            for (var k in items) {
                eachItem_(items[k], callback);
            }
        } else {
            if(typeof items["type"] !== 'undefined') {
                callback(items);
            }
            if(typeof items["children"] !== 'undefined') {
                eachItem_(items["children"], callback);
            }
        }
    }
    this.eachItem = function(items, callback) {
        console.warn("Global vis-ui.js window.DataUtil is deprecated and will be removed in v0.3");
        eachItem_(items, callback);
    };

    /**
     * Check if object has a key
     *
     * @param obj
     * @param key
     * @returns {boolean}
     */
    self.has = function(obj, key) {
        console.warn("Global vis-ui.js window.DataUtil is deprecated and will be removed in v0.3");
        return typeof obj[key] !== 'undefined';
    };

    /**
     * Get value from object by the key or return default given.
     *
     * @param obj
     * @param key
     * @param defaultValue
     * @returns {*}
     */
    self.getVal = function(obj, key, defaultValue) {
        console.warn("Global vis-ui.js window.DataUtil is deprecated and will be removed in v0.3");
        return has(obj, key) ? obj[key] : defaultValue;
    }
};

/**
 * String Helper library
 *
 * Using example:
 *      StringHelper.parseHttpRequest( location.href.split('#')[1] );
 *
 * @author Andriy Oblivantsev <eslider@gmail.com>
 * @copyright 27.01.2015 by WhereGroup GmbH & Co. KG
 * @deprecated all around useless with no known dependants
 * @todo: remove in v0.2.x
 */
window.StringHelper = new function() {

    var self = this;
    var reKeys = /[^\[\]]+/g;
    var reTiles = /[^=\?\&]+/g;

    /**
     * Get matched groups by RegExp
     *
     * @param reg
     * @param text
     * @return {Array}
     */
    self.matchGroups = function(reg, text) {
        var match;
        var result = [];
        while (match = reg.exec(text)) {
            result.push(match[0]);
        }
        return result;
    };

    /**
     * Cast string value to native type
     *
     * @param val
     * @return {*}
     */
    self.castValue = function(val) {
        var r;
        if(val == "false") {
            r = false;
        } else if(val == "true") {
            r = true;
        } else if(!isNaN(val)) {
            r = parseInt(val);
        } else {
            r = val;
        }
        return r;
    };

    /**
     * Parse and return HTTP request as an object
     *
     * @param url
     * @return {{}}
     */
    self.parseHttpRequest = function(uri) {
        var matches = uri ? self.matchGroups(reTiles, uri) : {};
        var len = matches.length;
        var result = {};
        var key, keyLength, subResult, keys, value, z, i;

        for (i = 0; i < len; i += 2) {
            keys = self.matchGroups(reKeys, matches[i]);
            value = self.castValue(matches[i + 1]);
            subResult = result;
            keyLength = keys.length;
            for (z = 0; z < keyLength; z++) {
                key = keys[z];
                if(z == keyLength - 1) {
                    subResult[key] = value;
                } else if(!subResult.hasOwnProperty(key)) {
                    subResult[key] = {};
                }
                subResult = subResult[key];
            }
        }
        return result;
    };
};

/**
 *
 * @author Andriy Oblivantsev <eslider@gmail.com>
 */
/**
 * Form helper plugin for jQuery
 *
 * @author Andriy Oblivantsev <eslider@gmail.com>
 * @copyright 02.02.2015 by WhereGroup GmbH & Co. KG
 *
 */
window.VisUi = window.VisUi || {};
window.VisUi.validateInput = function(input) {
    var $input = $(input);
    if ($input.attr('type') === 'radio') {
        // Individual radio buttons cannot be invalid and cannot be validated
        return;
    }
    var isValid = $input.is(':valid') || $input.get(0).type === 'hidden';
    var validationCallback = input.data('warn');
    if (isValid && validationCallback) {
        var value = $input.val();
        if (value === '') {
            isValid = validationCallback(null);
        } else {
            isValid = validationCallback(value);
        }
    }
    // NOTE: hidden inputs must be explicitly excluded from jQuery validation
    //       see https://stackoverflow.com/questions/51534473/jquery-validate-not-working-on-hidden-input
    var isValid = (!validationCallback || validationCallback(value)) && $input.is(':valid') || $input.get(0).type === 'hidden';
    var $formGroup = input.closest('.form-group');
    $formGroup.toggleClass('has-error', !isValid);
    $formGroup.toggleClass('has-success', isValid);
    var $messageContainer = $('.invalid-feedback', $formGroup);
    var invalidMessage = $input.attr('data-visui-validation-message');
    if (!isValid && invalidMessage && $input.is(":visible") && $input.attr('type') !== 'checkbox') {
        if (!$messageContainer.length) {
            $messageContainer = $(document.createElement('div')).addClass('help-block invalid-feedback');
            $formGroup.append($messageContainer);
        }
        $messageContainer.text(invalidMessage || '');
    }
    $messageContainer.toggle(!isValid);
    if (!isValid) {
        // Re-validate once on change, to make error message disappear
        $input.one('change', function() {
            VisUi.validateInput(input);
        });
    }
    // .has-warning is set initially to required inputs but its styling conflicts with .has-error / .has-success.
    // After validation, we always either .has-error or .has-success, so .has-warning needs to go
    $formGroup.removeClass('has-warning');
    return isValid;
};

$.fn.formData = (function() {
    function setValues(form, values) {
        $('.-visui-text-callback', form).each(function() {
            var textElement = $(this);
            var callback = textElement.data('visui-text-callback');
            /** @todo: why .html? .text would be safer */
            textElement.html(callback.call(null, values));
        });
        $(':input[name]', form).each(function() {
            var input = $(this);
            var value = values[this.name];

            if(values.hasOwnProperty(this.name)) {

                switch (this.type) {
                    case 'select-multiple':
                        if (value && !$.isArray(value)) {
                            var separator = input.attr('data-visui-multiselect-separator') || ',';
                            input.val(value.split(separator));
                        } else {
                            input.val(value);
                        }
                        break;
                    case 'checkbox':
                        input.prop('checked', value !== null && value);
                        break;
                    case 'radio':
                        if (value === null) {
                            input.prop('checked', false);
                        } else if (input.val() == value) {
                            input.prop("checked", true);
                        }
                        break;
                    case 'hidden':
                        input.val(value);
                        input.trigger('change');
                        break;

                    case 'text':
                        if(input.hasClass('hasDatepicker')) {
                            if(value === '' || value === 0 || value === '0') {
                                value = null;
                            }

                            input.datepicker("setDate", value);
                            input.datepicker("refresh");
                        } else {
                            input.val(value);
                        }
                        break;
                    default:
                        input.val(value);
                        break;
                }
                // Use scoped events to visually update select2 / colorpicker, if initialized
                // @todo: ... why exactly do we avoid triggering regular 'change', except for 'hidden'-type inputs?
                input.trigger('change.select2');
                /** magical 'filled' event, purpose unknown. Emit warnings on event data property access */
                var filledEventData = {};
                Object.defineProperties(filledEventData, {
                    data: {
                        get: function() {
                            console.warn("Stop subscribing to custom 'filled' event. Explicitly call your code after repopulating a form.");
                            return values;
                        }
                    },
                    value: {
                        get: function() {
                            console.warn("Stop subscribing to custom 'filled' event. Explicitly call your code after repopulating a form.");
                            return value;
                        }
                    }
                });

                input.trigger('filled', filledEventData);
                input.trigger('change.colorpicker');
            }
        });
        return form;
    }
    function getValues(form) {
        var values = {};
        var firstInput;
        $(':input[name]', form).each(function() {
            var input = $(this);
            var value;

            // Ignore unchecked radios to avoid replacing previous checked radio value with the same name attribute
            // NOTE: vis-ui itself makes it possible to generate radio button groups where no radio button is checked
            //       For these cases, we cannot skip all unchecked radios. We have to evaluate at least one, to generate
            //       an empty value.
            if (this.type === 'radio' && values[this.name] && !this.checked) {
                return;
            }

            switch (this.type) {
                case 'checkbox':
                case 'radio':
                    value = input.is(':checked') && input.val();
                    break;
                default:
                    value = input.val();
                    break;
            }

            if (value === "" || (this.type === 'radio' && !this.checked)) {
                value = null;
            }
            var isValid = VisUi.validateInput(input);
            if (!isValid && !firstInput) {
                var $tabElement = input.closest('.ui-tabs');
                var tabIndex = $tabElement.length && input.closest('.ui-tabs-panel').index('.ui-tabs-panel');
                if ($tabElement) {
                    $tabElement.tabs({active: tabIndex});
                }
                firstInput = input;
                input.focus();
            }

            values[this.name] = value;
        });
        return values;
    }
    function handleArgs(values) {
        if (values) {
            return setValues($(this), values);
        } else {
            return getValues($(this));
        }
    }
    return handleArgs;
})();

$.fn.disableForm = function() {
    var form = this;
    var inputs = $(" :input", form);
    form.attr('readonly', true);
    form.css('cursor', 'wait');
    $.each(inputs, function(idx, el) {
        var $el = $(el);
        if($el.is(':checkbox') || $el.is(':radio') || $el.is('select')) {
            $el.attr('disabled', 'disabled');
        } else {
            $el.attr('readonly', 'true');
        }
    })
};

$.fn.enableForm = function() {
    var form = this;
    var inputs = $(" :input", form);
    form.css('cursor', '');
    $.each(inputs, function(idx, el) {
        var $el = $(el);
        if($el.is(':checkbox') || $el.is(':radio') || $el.is('select')) {
            $el.removeAttr('disabled', 'disabled');
        } else {
            $el.removeAttr('readonly', 'true');
        }
    })
};



/**
 * Confirm dialog
 *
 * Example:
 *     confirmDialog({html: "Remove?", title: "Please confirm!", onSuccess:function(){
                  return false;
       }});
 * @param options
 * @returns {*}
 */
window.confirmDialog = function(options) {
    var dialog = $("<div class='confirm-dialog'>" + (options.hasOwnProperty('html') ? options.html : "") + "</div>").popupDialog({
        title:       options.hasOwnProperty('title') ? options.title : "",
        maximizable: false,
        dblclick:    false,
        minimizable: false,
        resizable:   false,
        collapsable: false,
        modal:       true,
        buttons:     [{
            text:  "OK",
            click: function(e) {
                if(!options.hasOwnProperty('onSuccess') || options.onSuccess(e) !== false) {
                    dialog.popupDialog('close');
                }
                return false;
            }
        }, {
            text:    "Cancel",
            'class': 'critical',
            click:   function(e) {
                if(!options.hasOwnProperty('onCancel') || options.onCancel(e) !== false) {
                    dialog.popupDialog('close');
                }
                return false;
            }
        }]
    });
    return dialog;
};
(function($) {
    /**
     * Mapbender result table element.
     * Uses DataTables API
     *
     * @see http://datatables.net/reference/api/
     *
     * @example $('<div/>').resultTable( lengthChange: false,
     searching:    false,
     info:         false,
     columns:      [{data: 'id', title: 'ID'}, {data: 'label', title: 'Title'}],
     data:         [{id: 1, label: 'example'}]
     * @todo: Get this over into a separate repository (WITH a working stylesheet) or into Mapbender (current location of required stylesheet)
     *        it makes no sense to have markup generation and css class modifiers here, separate from the stylesheets that make it work
     */
    $.widget("vis-ui-js.resultTable", {

        _table:     null,
        _dataTable: null,
        _selection: null,

        /**
         * Constructor.
         *
         * @private
         */
        _create: function() {
            var widget = this;
            var el = $(widget.element);
            var table = widget._table = $('<table class="table table-striped table-hover"></table>');
            var options = widget.options;
            var isSelectable = _.has(options, 'selectable') && options.selectable;
            var hasBottomNavigation = _.has(options, 'bottomNavigation') && _.isArray(options.bottomNavigation);
            var hasRowButtons = options.hasOwnProperty('buttons');
            var dataTableContainer;

            el.append(table);
            el.addClass('mapbender-element-result-table');

            if(isSelectable) {
                widget._addSelection();
            }

            if(hasRowButtons) {
                widget._addButtons(options.buttons);
            }
            var dataTable = widget._dataTable = table.DataTable($.extend({
                "oLanguage": {
                    sEmptyTable: "0 / 0",
                    sInfo:      "_START_ / _END_ (_TOTAL_)",
                    "oPaginate": {
                        "sSearch":   "Filter:",
                        "sNext":     "Weiter",
                        "sPrevious": "Zurück"
                    }
                }
            },options));

            dataTableContainer = table.closest('.dataTables_wrapper');
            dataTableContainer.find('.dataTables_paginate a').addClass('button');

            if(isSelectable) {

                var selectionManager = widget.getSelection();

                dataTable.on('page', function() {

                    $.each(dataTable.$('tr'), function() {
                        var tr = this;
                        var rowData = widget.getDataByRow(tr);
                        var foundData = null;

                        $.each(selectionManager.list,function(){
                            var selectedData = this;
                            if(rowData == selectedData){
                                foundData = selectedData;
                                return false;
                            }
                        });

                        var $tr = $(tr);
                        var checkbox = $('td.selection input[type=checkbox]', $tr);

                        if(foundData) {
                            checkbox.prop('checked', true);
                            $tr.addClass('warning');
                        }else{
                            checkbox.prop('checked', false);
                            $tr.removeClass('warning');
                        }
                    });
                });

                selectionManager.on('add', function(data) {
                    var tr = widget.getRowByData(data);
                    if(!tr){
                        return;
                    }
                    var checkbox = $('td.selection input[type=checkbox]', tr);
                    checkbox.prop('checked', true);
                    tr.addClass('warning');
                }).on('remove', function(data) {
                    var tr = widget.getRowByData(data);
                    if(!tr){
                        return;
                    }
                    $('td.selection input[type=checkbox]', tr).prop('checked', false);
                    tr.removeClass('warning');
                });

                $(table).delegate("tbody>tr[role='row']", 'click', function(e) {
                    var tr = $(this);
                    var isSelected = !tr.hasClass('warning');
                    var data = dataTable.row(this).data();

                    if(isSelected) {
                        selectionManager.add(data);
                    } else {
                        selectionManager.remove(data);
                    }
                });
            }

            if(hasRowButtons) {
                $.each(options.buttons, function(idx, button) {
                    if(!button.hasOwnProperty('onClick') && !button.hasOwnProperty('click'))
                        return;

                    $(table).delegate("tbody>tr[role='row'] button." + button.className, 'click', function(e) {
                        var $button = $(this);
                        var data = dataTable.row($button.closest('tr')[0]).data();
                        e.stopPropagation();
                        if(button.click && typeof button.click == "function"){
                            $button.data("item", data);
                            $.proxy(button.click, $button)(e);
                        }else{
                            button.onClick(data, $button, e);
                        }
                    });
                });
            }

            if(hasBottomNavigation) {
                this.addBottomNavigation(options.bottomNavigation);
            }
        },

        genNavigation: function(elements) {
            var html = $('<div class="button-navigation"/>');
            $.each(elements, function(idx, element) {

                var type = 'button';
                if(_.has(element,'type')){
                    type = element.type;
                }else if(_.has(element,'html')){
                    type = 'html';
                }

                switch(type){
                    case 'html':
                        html.append(element.html);
                        break;
                    case 'button':
                        var button = $('<button/>');
                        button.attr({
                            'class': 'button',
                            title: element.title || null
                        });
                        button.text(element.text || undefined);
                        button.addClass(element.cssClass || null);
                        if(_.has(element,'className')){
                            button.addClass("icon-"+element.className);     // why?
                            button.addClass( element.className);
                        }

                        html.append(button);
                        break;
                }
            });
            return html;
        },

        /**
         * Get DataTables API
         * @see http://datatables.net/reference/api/
         */
        getApi: function() {
            return this._dataTable;
        },
        
        /**
         * Get widget itself
         * 
         * @returns widget
         */
        getWidget: function(){
            return this;
        },

        /**
         * Get selection manager
         */
        getSelection: function() {
            var widget = this;
            if(!widget._selection) {
                widget._selection = $.extend(true, new function() {
                    var me = this;
                    var list = me.list = [];
                    this.table = widget._table;

                    /**
                     * Add selection
                     *
                     * @param data
                     */
                    me.add = function(data) {
                        if(_.indexOf(list,data) != -1){
                            return this;
                        }
                        list.push(data);
                        me.dispatch('add', data);
                        me.dispatch('change', list);
                        return this;
                    };

                    /**
                     * Remove selection
                     * @param data
                     * @return {boolean}
                     */
                    me.remove = function(data) {
                        if(_.indexOf(list, data) == -1) {
                            return this;
                        }
                        list.splice(_.indexOf(list, data), 1);
                        me.dispatch('remove', data);
                        me.dispatch('change', list);
                        return this;
                    };
                }, widget._eventDispatcher);
            }
            return widget._selection;
        },

        /**
         * Set option listener
         *
         * @param key
         * @param value
         * @private
         */
        _setOption: function(key, value) {
            switch (key) {
                case "data":
                    this.setData(value);
            }
        },

        /**
         * Set table data
         *
         * @param data
         */
        setData: function(data) {
            var options = $.extend(this.options, {aaData: data});
            this.options.data = data;
            this._dataTable.destroy();
            this._dataTable = $(this._table).DataTable(options);
        },

        _addSelection: function() {
            var options = this.options;
            var columns = options.columns;

            options.columns = _.union([{
                data:  null,
                title: ''
            }], columns);

            var columnDef = [{
                targets:        0,
                className:      'selection',
                width:          "1%",
                orderable:      false,
                searchable:     false,
                defaultContent: '<input type="checkbox" value="1"/>'
            }];

            // merge definitions
            options.columnDefs = options.hasOwnProperty('columnDefs') ? _.flatten(options.columnDefs, columnDef) : columnDef;
        },

        _addButtons: function(buttons) {
            var options = this.options;

            options.columns.push({
                data:  null,
                title: ''
            });

            var columnDef = [{
                targets:        -1,
                className:      'buttons',
                width:          "1%",
                orderable:      false,
                searchable:     false,
                defaultContent: $('<div>').append(this.genNavigation(options.buttons).clone()).html()
            }];

            // merge definitions
            options.columnDefs = options.hasOwnProperty('columnDefs') ? _.union(options.columnDefs, columnDef) : columnDef;
        },

        /**
         *
         * @param buttons
         * @return {*}
         */
        addBottomNavigation: function(buttons) {
            var widget = this;
            var el = $(widget.element);
            var options = widget.options;
            var navigation = widget.genNavigation(buttons).addClass('bottom-navigation');

            $('button', navigation).on('click', function(event) {
                var button = $(event.currentTarget);
                // find and run callback, if defined in configuration
                $.each(options.bottomNavigation, function(idx, config) {
                    if(button.hasClass(config.className) && config.hasOwnProperty('onClick')) {
                        config.onClick($.extend(event, {
                            widget:    widget,
                            dataTable: widget._dataTable,
                            table:     widget._table,
                            config:    config
                        }));
                    }
                });
            });

            el.append(navigation);

            return navigation;
        },

        getRowByData: function(data) {
            var widget = this;
            var r = null;
            $.each(widget.getVisibleRows(), function() {
                if(widget.getDataByRow(this) == data) {
                    r = $(this);
                    return false;
                }
            });
            return r;
        },

        getVisibleRows: function() {
            return $(">tbody>tr[role='row']", this._table);
        },

        getVisibleRowData: function() {
            var list = [];
            var widget = this;

            $.each(widget.getVisibleRows(), function() {
                list.push(widget.getDataByRow(this));
            });

            return list;
        },

        getDataByRow: function(tr) {
            return this._dataTable.row(tr).data();
        },

        selectVisibleRows: function() {
            var widget = this;
            var selectionManager = widget.getSelection();
            $.each(widget.getVisibleRows(), function() {
                selectionManager.add(widget.getDataByRow(this));
            });
        },

        // TODO: realize
        selectAll: function() {
            var widget = this;
            var selectionManager = widget.getSelection();
            $.each(widget._dataTable.data(), function() {
                selectionManager.add(this);
            });
        },

        deselectVisibleRows: function() {
            var widget = this;
            var selectionManager = widget.getSelection();
            $.each(widget.getVisibleRows(), function() {
                selectionManager.remove(widget.getDataByRow(this));
            });
        },

        // TODO: realize
        deselectAll: function() {
            var widget = this;
            var selectionManager = widget.getSelection();
            $.each(widget._dataTable.data(), function() {
                selectionManager.remove(this);
            });
        },

        hasUnselectedVisibleRows: function() {
            var r = false;
            $.each(this.getVisibleRows(),function(){
                if(!$(this).hasClass('warning')){
                    r = true;
                    return false;
                }
            });
            return r;
        },
        
        /**
         * 
         * @param {type} id
         * @param {type} key
         * @returns {@exp;selector|@exp;seed@pro;length|@exp;selector@call;slice|String|@exp;compiled@pro;selector|@exp;selector@call;replace|@exp;handleObjIn@pro;selector|until|seed.length|compiled.selector|handleObjIn.selector|@exp;type|@exp;type@call;slice|@exp;callback|@exp;props|@exp;params|@arr;@this;|@exp;data|@exp;speed|@exp;options|Array|@exp;props@call;split|@exp;jQuery@call;param|@exp;query@call;split|@exp;jQuery@call;makeArray|@exp;selectorundefined|@exp;options@pro;duration|@exp;_@call;extend|options|@exp;s@call;join@call;replace|selectorundefined|_@call;extend.duration|options.duration}Get data by id
         */
        getDataById: function(value, key){    
            var result;
            
            if(!key){
                key = 'id'
            }
            $.each(this.getApi().data(),function(i, data){
                if(value === data[key]){
                    result = data;
                    return false
                }
            });
            return result;
        },

        /**
         * Get DOM TR row by data object
         * @param {type} DOM object
         * @returns {undefined}
         */
        getDomRowByData: function(data) {
            var tableApi = this.getApi();
            var result = _.first(tableApi.rows(function(idx, _data, row) {
                return _data == data
            }).nodes());

            return result ? $(result) : result;
        },
        
        /**
         * Show by DOM row
         * @return int page number
         */
        showByRow: function(domRow){
            var tableApi =  this._dataTable;
            var rowsOnOnePage = tableApi.page.len();

            if(domRow.hasOwnProperty('length')){
                domRow = domRow[0]
            }
            
            var nodePosition = tableApi.rows({order: 'current'}).nodes().indexOf(domRow);
            var pageNumber = Math.floor(nodePosition / rowsOnOnePage);
            tableApi.page(pageNumber).draw( false );
            return pageNumber;
        },
        _eventDispatcher: {
            _listeners: {},

            on: function(name,callback){
                if(!this._listeners[name]){
                    this._listeners[name] = [];
                }
                this._listeners[name].push(callback);
                return this;
            },

            off: function(name,callback){
                if(!this._listeners[name]){
                    return;
                }
                if(callback){
                    var listeners = this._listeners[name];
                    for(var i in listeners){
                        if(callback == listeners[i]){
                            listeners.splice(i,1);
                            return;
                        }
                    }
                }else{
                    delete this._listeners[name];
                }

                return this;
            },

            dispatch: function(name,data){
                if(!this._listeners[name]){
                    return;
                }

                var listeners = this._listeners[name];
                for(var i in listeners){
                    listeners[i](data);
                }
                return this;
            }
        }
    });

})(jQuery);

(function($) {

    /**
     * Date selector based on $.ui.datepicker
     * Replacement for <input type="date"> for browsers without proper HTML5 supprt.
     * Hard-coded to German locale.
     * Accepts no options. Accepting any options would conflict with operation of native HTML5 inputs.
     *
     * Widget can't be extended:
     * http://bugs.jqueryui.com/ticket/6228
     *
     * @author Andriy Oblivantsev <eslider@gmail.com>
     */
    $.widget("vis-ui-js.dateSelector", {
        _init: function() {
            var $input = $('input', this.element);
            var datePicker = $input.datepicker({
                changeMonth:       true,
                changeYear:        true,
                gotoCurrent:       true,
                defaultDate:       null,
                firstDay:          1, //showWeek:          true,
                dayNamesMin:       ["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"],
                monthNamesShort:   ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"], //showButtonPanel: true,
                dateFormat:        'yy-mm-dd'
            }).data('datepicker');
            // legacy styling hacks
            // @todo: style via proper datepicker selectors in proper scope, do not add random classes that "seem to work"
            // @todo: better yet, use original jquery ui css to style original jquery ui widgets
            datePicker.dpDiv.addClass('dropdown-menu').addClass('modal-body');
        }
    });

})(jQuery);

(function($) {
    // fake dialogExtend check for ui-dialog
    if (!$.fn.orignalDialogFunc) {
        // sic!
        $.fn.orignalDialogFunc = $.fn.dialog;
    }
    var $doc = $(document);
    if (!$doc.data('visui-monkeypatch-uidialog')) {
        $.fn["dialog"] = function(arg1, arg2) {
            return this.hasClass('popup-dialog') ? this.popupDialog(arg1, arg2) :  this.orignalDialogFunc(arg1, arg2);
        };
        $doc.data('visui-monkeypatch-uidialog', true);
    }

    /**
     * jQueryui dialog with unholy mix of bootstrap and Mapbender custom styles
     *
     * @author Andriy Oblivantsev <eslider@gmail.com>
     * @copyright 05.11.2014 by WhereGroup GmbH & Co. KG
     * @todo: Get this over into a separate repository (WITH a working stylesheet) or into Mapbender (current location of required stylesheet)
     *        it makes no sense to have markup generation and css class modifiers here, separate from the stylesheets that make it work
     */
    $.widget("vis-ui-js.popupDialog", $.ui.dialog, {
        /**
         * @return {*}
         * @private
         */
        _create: function() {
            var element = this.element;
            // Unholy mix of jQuery UI and Bootstrap and Mapbender CSS
            element.addClass('popup-dialog');
            element.addClass('modal-body');

            // overrides default options
            $.extend(this.options, {
                show: {
                    effect:   "fadeIn",
                    duration: 300
                },
                hide: {
                    effect:   "fadeOut",
                    duration: 300
                }
            });

            //resize dialog height fix
            element.bind('popupdialogresize', function(e, ui) {
                var win = $(e.target).closest('.ui-dialog');
                var height = 0;
                $.each($('> .modal-header, > .modal-body, > .modal-footer', win), function(idx, el) {
                    height += $(el).outerHeight();
                });
                win.height(Math.round(height));
                element.width(element.closest('.ui-dialog').find('> .modal-header').width());
            });

            //resize dialog height fix
            element.bind('popupdialogresizestop', function(e, ui) {
                element.width(element.closest('.ui-dialog').find('> .modal-header').width());
            });

            // prevent key listening outside the dialog
            element.on('keydown', function(e) {
                e.stopPropagation();
            });

            this._super();
        },
        _createTitlebar: function() {
            this._super();
            if (this.element.dialogExtend) {
                // NOTE: no widget-level options defaults for these
                var extendableOptions = $.extend(true, {
                    closable:    true,
                    maximizable: true,
                    collapsable: true
                }, this.options);

                this.element.data("ui-dialog", true);
                if (extendableOptions.maximizable && (typeof this.options.dblclick === 'undefined')) {
                    extendableOptions.dblclick = 'maximize';
                }

                this.element.dialogExtend(extendableOptions);
            }
            // Unholy mix of jQuery UI and Bootstrap and Mapbender CSS
            this.uiDialogTitlebar.addClass('modal-header');
            // @todo Mapbender: resolve Mapbender css dependency on generally not advantageous bootstrap .close class
            //                  to generate consistent close button vs jquerydialogextend not-really-button visuals
            $('.ui-dialog-titlebar-close', this.uiDialogTitlebar).addClass('close');
        },
        open: function() {
            this._super();
            if (this.overlay) {
                this.overlay.addClass('mb-element-modal-dialog');
            }
        },
        _createWrapper: function() {
            this._super();
            // Unholy mix of jQuery UI and Bootstrap and Mapbender CSS
            this.uiDialog.addClass('modal-content mb-element-popup-dialog');
        },
        _createButtonPane: function() {
            // Unholy mix of jQuery UI and Bootstrap and Mapbender CSS
            this._super();
            this.uiDialogButtonPane.addClass('modal-footer');
        },
        _createButtons: function() {
            this._super();
            $('button', this.uiButtonSet).each(function() {
                var $b = $(this);
                // leave fully formed Bootstrap buttons alone; add Mapbender .button (for default color) plus
                // Bootstrap .btn (for margin) otherwise
                if (!$b.hasClass('btn')) {
                    $(this).addClass('button btn');
                }
            });
        }
    });

})(jQuery);

(function($) {

    /**
     * jQuery tabs with bootstrap styles and auto-generation of tab headers and content panels
     * Internally unreachable
     */
    $.widget("vis-ui-js.tabNavigator", $.ui.tabs, {
        options: {
        },
        _create: function() {
            var widget = this;
            var options = widget.options;
            var el = widget.element;
            if (!this._getList().length) {
                this.element.prepend('<ul/>');
            }
            this._getList().addClass('nav nav-tabs');

            el.addClass('mapbender-element-tab-navigator');

            if(options.hasOwnProperty('children')){
                // internally unreachable path
                $.each(options.children,function(){
                    var $tab = widget._add(this);
                    $tab.data('item', this);
                });
                el.on('tabnavigatoractivate',function(e,ui) {
                    var item = $(ui.newTab).data('item');
                    if(item.hasOwnProperty('active')){
                        item.active(e,ui);
                    }
                });
            }

            return this._super();
        },
        /**
         * Static (no this context)
         * @param {jQuery} $panel
         * @param {String} title
         * @return {jQuery}
         */
        _renderTab: function($panel, title) {
            var $anchor = $('<a>')
                .attr('href', '#' + $panel.attr('id'))
                .text(title)
            ;
            return $('<li>')
                .append($anchor)
            ;
        },
        /**
         * Static (no this context)
         * @param {(jQuery|String)} content
         * @private
         */
        _renderPanel: function(content) {
            return $("<div>")
                .uniqueId()
                .addClass('tab-content')
                .append(content)
            ;
        },
        _add: function (item){
            var $panel = this._renderPanel(item.html);
            var $tab = this._renderTab($panel, item.title);
            this._getList().append($tab);
            this.element.append($panel);
            return $tab;
        },

        add: function(title, htmlElement, activate) {
            var content = this._add({
                html:  htmlElement,
                title: title
            });
            if(activate) {
                this.option('active', this.size() - 1);
            }
            this.refresh();
            return content;
        },

        size: function() {
            return this.tabs.length;
        }
    });
})(jQuery);

/**
 *
 * @author Andriy Oblivantsev <eslider@gmail.com>
 * @copyright 08.04.2015 by WhereGroup GmbH & Co. KG
 */
(function($) {

    /**
     * Event list
     * @type {string[]}
     */
    var eventNameList = [
        'load',
        'focus', 'blur',
        'input', 'change', 'paste',
        'click', 'dblclick', 'contextmenu',
        'keydown', 'keypress', 'keyup',
        'dragstart','ondrag','dragover','drop',
        'mousedown', 'mouseenter', 'mouseleave', 'mousemove', 'mouseout', 'mouseover', 'mouseup',
        'touchstart', 'touchmove', 'touchend','touchcancel',
        'filled'
    ];

    // extend jquery to fire event on "show" and "hide" calls
    // @todo: this is bad practice and should be removed ASAP. Figure out who even uses this.
    $.each(['show', 'hide'], function (i, ev) {
        var el = $.fn[ev];
        $.fn[ev] = function () {
            this.trigger(ev);
            return el.apply(this, arguments);
        };
    });

    function isNode(x) {
        // Minimum (DOM level 1) criteria for DOM Nodes or text nodes
        // see https://www.w3.org/TR/REC-DOM-Level-1/ecma-script-language-binding.html
        return x && x.nodeType && x.nodeName;
    }

    /**
     * @param {String} expr
     * @return {RegExp|null}
     */
    function expressionToRegex(expr) {
        // for valid flags see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_Expressions#Advanced_searching_with_flags
        var matches = expr.match(/^[/](.*?)[/]([gimsuy]*)$/);
        if (matches) {
            return new RegExp(matches[1], matches[2]);
        } else {
            return null;
        }
    }

    /**
     * Check if typeof object[key] !== 'undefined'
     *
     * @param obj
     * @param key
     * @returns {boolean}
     */
    function has(obj, key) {
        return typeof obj[key] !== 'undefined';
    }

    function genElement_(declarations, item) {
        if (isNode(item)) {
            return item;
        }
        // @todo: explicitly warn / err on undefined type (there will be an error on calling undefined as a function, but it won't be informative)
        // @todo: fallback to html should ONLY be allowed if the item is a plain string
        var type = has(declarations, item.type) ? item.type : 'html';
        // Use declarations object as this argument for handler function.
        // Do not "beautify" this into discrete assignment of callable to variable followed by invocation, because
        // THAT passes nothing of particular interest as the invoked method's this arg.
        // see https://ecma-international.org/ecma-262/5.1/#sec-4.3.27
        var element = (declarations[type])(item);

        if(has(item, 'cssClass')) {
            element.addClass(item.cssClass);
        }

        if(has(item, 'attr')) {
            $.each(item.attr, function(key, val) {
                element.attr(key,val);
            });
        }

        if(typeof item == "object") {
            addEvents(element, item);
        }

        if(has(item, 'css')) {

            element.css(item.css);
        }

        // @todo: remove excessive data bindings
        element.data('item', item);

        return element;
    }

    function genElements_(declarations, items) {
        var items_;
        if (!_.isArray(items)) {
            // @todo: warn, deprecate
            items_ = _.toArray(items);
        } else {
            items_ = items;
        }
        var elements = [];
        for (var i = 0; i < items_.length; ++i) {
            elements.push(genElement_(declarations, items_[i]));
        }
        return elements;
    }
    /**
     * Add jquery events to element y declration
     *
     * @param element
     * @param declaration
     */
    function addEvents(element, declaration) {
        $.each(declaration, function(k, value) {
            if(typeof value == 'function') {
                element.on(k, value);
            } else if(typeof value == "string" && _.contains(eventNameList, k)) {
                var elm = element;
                if(elm.hasClass("form-group")) {
                    elm = elm.find("input,.form-control");
                }
                if(k === 'load'){
                    setTimeout(function(){
                        $(elm).ready(function(e) {
                            var el = elm;
                            var result = false;
                            console.error("Using Javascript code in the configuration is deprecated",value);
                            eval(value);
                            result && e.preventDefault();
                            return result;
                        });
                    },1);
                }else{
                    elm.on(k, function(e) {
                        var el = $(this);
                        var result = false;
                        console.error("Using Javascript code in the configuration is deprecated",value);
                        eval(value);
                        result && e.preventDefault();
                        return result;
                    });
                }
            }
        });
    }

    // Copies a string to the clipboard. Must be called from within an
    // event handler such as click. May return false if it failed, but
    // this is not always possible. Browser support for Chrome 43+,
    // Firefox 42+, Safari 10+, Edge and IE 10+.
    // IE: The clipboard feature may be disabled by an administrator. By
    // default a prompt is shown the first time the clipboard is
    // used (per session).
    function copyToClipboard(text) {
        if (window.clipboardData && window.clipboardData.setData) {
            // IE specific code path to prevent textarea being shown while dialog is visible.
            return clipboardData.setData("Text", text);

        } else if (document.queryCommandSupported && document.queryCommandSupported("copy")) {
            var textarea = document.createElement("textarea");
            textarea.textContent = text;
            textarea.style.position = "fixed";  // Prevent scrolling to bottom of page in MS Edge.
            document.body.appendChild(textarea);
            textarea.select();
            try {
                return document.execCommand("copy");  // Security exception may be thrown by some browsers.
            } catch (ex) {
                console.warn("Copy to clipboard failed.", ex);
                return false;
            } finally {
                document.body.removeChild(textarea);
            }
        }
    }
    var readOnlyDeclarations = {
        genElement_: genElement_,
        genElements_: genElements_
    };

    var browserSupportsHtml5Date = (function() {
        // detect support for HTML5 date input; see https://stackoverflow.com/a/10199306
        var dateInput = document.createElement('input');
        var invalidDate = 'not-a-date';
        dateInput.setAttribute('type', 'date');
        dateInput.setAttribute('value', invalidDate);
        return dateInput.value !== invalidDate;
    })();
    var isValidatingInput = function(item) {
        var attr = item.attr || {};
        return item.name && item.type !== 'radio' && (item.mandatory || attr.required || attr.pattern);
    };
    var isRequiredInput = function(item) {
        var attr = item.attr || {};
        return item.name && item.type !== 'radio' && (item.mandatory || attr.required);
    };
    var wrapGroup = function(contents, required) {
        var container = $('<div class="form-group"/>');
        if (required) {
            container.addClass('has-warning');
        }
        container.append(contents);
        return container;
    };
    var setBaseInputProps = function(input, item) {
        $(input).attr({
            type: $(input).attr('type') || (item.type !== 'input' && item.type) || 'text',
            name: item.name || null
        });
        $(input).prop({
            required: isRequiredInput(item),
            disabled: item.disabled
        });
    };
    var setTextInputProps = function(input, item) {
        var attr = item.attr || {};
        setBaseInputProps(input, item);
        input.attr({
            placeholder: attr.placeholder || item.placeholder || null
        });

        if (typeof(item.value) !== 'undefined') {
            input.val(item.value);
        }
    };

    // NOTE: bad indents deliberate to minimize diff
    var defaultDeclarations = $.extend({}, readOnlyDeclarations, {
            copyToClipboard: copyToClipboard,
            popup: function(item) {
                var popup = $("<div/>");
                popup.append(this.genElements_(this, item.children || []));
                window.setTimeout(function() {
                    popup.popupDialog(item)
                }, 1);

                return popup;
            },
            form: function(item) {
                var form = $('<form/>').attr(item.attr || {});
                form.append(this.genElements_(this, item.children || []));
                return form;
            },
            fluidContainer: function(item) {
                var container = $('<div/>').attr(item.attr || {}).addClass('container-fluid');
                var hbox = $('<div/>').attr(item.rowAttr || {}).addClass('row');
                hbox.append(this.genElements_(this, item.children || []));
                container.append(hbox);
                return container;
            },
            inline: function(item) {
                var container = $('<div/>').attr(item.attr || {}).addClass('form-inline');
                container.append(this.genElements_(this, item.children || []));
                return container;
            },
            html: function(item) {
                var container = $('<div/>').attr(item.attr || {}).addClass('html-element-container');
                if (typeof item === 'string'){
                    container.html(item);
                } else if (typeof item.html !== 'undefined') {
                    container.html(item.html);
                }else{
                    // WHAT?
                    container.html(JSON.stringify(item));
                }
                return container;
            },
            button: function(item) {
                var title = has(item, 'title') ? item.title : 'Submit';
                // @todo: use .text for escaping (unless it's HTML again :\)
                var button = $('<button>' + title + '</button>').attr(item.attr || {}).addClass('btn button');
                button.attr("title", (item.attr || {}).title || item.hover || title);
                return button;
            },
            submit: function(item) {
                var item_ = $.extend({}, item, {
                    attr: $.extend({}, (item. attr || {}), {
                        type: 'submit'
                    })
                });
                return this.button(item_);
            },
            /**
             * WRAPS the passed input into a form group
             *
             * @param {Object} item
             * @param {jQuery} [input] manufactures a new text-type input if omitted
             * @return {*|jQuery|HTMLElement}
             */
            input: function(item, input) {
                // @todo: fold very apparent copy & paste between this method and "checkbox" method
                var inputField = input;
                if (!input) {
                    var type = (item.type !== 'input' && item.type) || 'text';
                    inputField = $('<input class="form-control" type="' + type + '"/>');
                    inputField.attr(item.attr || {});
                }
                // @todo: remove excessive data bindings
                inputField.data('declaration',item);
                setTextInputProps(inputField, item);

                var label;
                if (item.title) {
                    label = this.label(item);
                }

                if (item.mandatory) {
                    var validationCallback;
                    if (item.mandatory === true) {
                        validationCallback = function(value) {
                            return $.trim(value).length;
                        };
                    } else if (typeof item.mandatory === 'string') {
                        // legacy fun fact: string runs through eval, but result of eval can only be used
                        // if it happens to have an method named .exec accepting a single parameter
                        // => this was never compatible with anything but regex literals
                        var rxp = expressionToRegex(item.mandatory);
                        if (rxp) {
                            validationCallback = function(value) {
                                return rxp.test(value);
                            }
                        }
                    }
                    if (!validationCallback) {
                        console.error("Invalid value in item.mandatory. Use boolean true or a regex literal.", item.mandatory, item);
                        throw new Error("Invalid value in item.mandatory. Use boolean true or a regex literal.");
                    }
                    // @todo: why in the world is this a data attribute? Validation belongs in a form submit handler.
                    //        HTML5 validation already does most of this without custom logic
                    inputField.data('warn', validationCallback);
                }
                if (item.mandatoryText) {
                    inputField.attr('data-visui-validation-message', item.mandatoryText);
                }

                if (label && item.copyClipboard) {
                    label.append('&nbsp;', $('<i/>')
                        .addClass('fa fa-clipboard far-clipboard -visui-copytoclipboard')
                        .attr('aria-hidden', 'true')
                    );
                }
                return wrapGroup([label, inputField], isValidatingInput(item));
            },
            label: function(item) {
                var label = $('<label/>');
                if(_.has(item, 'text')) {
                    label.html(item.text);
                }
                if(_.has(item, 'title')) {
                    label.html(item.title);
                }
                if(_.has(item, 'name')) {
                    label.attr('for', item.name);
                }
                if (item.infoText) {
                    var $icon = $('<i/>')
                        .addClass('fa fa-info-circle -visui-infotext')
                        .attr('title', item.infoText)
                    ;
                    label.append('&nbsp;', $icon);
                }

                return label;
            },
            checkbox: function(item) {
                var label = this.label(item);
                var input = $('<input type="checkbox"/>');
                label.prepend(input);

                setBaseInputProps(input, item);
                input.attr('value', item.value || null);
                input.prop('checked', !!item.checked);
                var container = wrapGroup([label], isRequiredInput(item));
                container.addClass('checkbox');
                return container;
            },
            radio: function(item) {
                var input = $('<input type="radio"/>');
                var $label = this.label(item);
                setBaseInputProps(input, item);
                input.prop('checked', !!item.checked);
                input.attr('value', item.value || null);
                $label.prepend(input);
                var container = wrapGroup([$label], false);
                container.addClass('radio');
                return container;
            },
            formGroup: function(item) {
                var container = $('<div class="form-group"/>');
                container.append(this.genElements_(this, item.children || []));
                return container;
            },
            textArea: function(item) {
                var inputField = $('<textarea class="form-control" rows="3"/>');
                var container = this.input(item, inputField);
                container.addClass('textarea-container');

                inputField.attr('rows', item.rows || 3);

                return container;
            },
            selectOption: function(item, option) {
                var label, value;
                var labelAttribNames = ['label', '__label', 'title'];
                var valueAttribNames = ['value', '___value', 'id'];
                var noLabel = true;
                var noValue = true;
                var i = 0;
                do {
                    label = option[labelAttribNames[i]];
                    noLabel = (typeof label === 'undefined');
                    ++i;
                } while (noLabel && i < labelAttribNames.length);
                i = 0;
                do {
                    value = option[valueAttribNames[i]];
                    noValue = (typeof value === 'undefined');
                    ++i;
                } while (noLabel && i < valueAttribNames.length);
                if (noLabel || noValue) {
                    var optionAsList = _.toArray(option);
                    if (optionAsList.length < 2) {
                        console.error("Invalid option input, need at least a label and a value", option);
                        return null;    // will be skipped by $.append
                    }
                    if (_.isArray(option) && optionAsList.length > 2) {
                        console.warn("List-style option with more than two entries, results unpredictable. Use an object with 'value' and 'label' instead", option);
                    }
                    if (noValue) {
                        value = optionAsList[0];
                    }
                    if (noLabel) {
                        label = optionAsList[1];
                    }
                }
                var attr = $.extend({}, option.attr, {value: value});
                var $option = $('<option/>')
                    .attr(attr)
                    // Label has historically been set through .html instead of .text ...
                    // @todo: html seems super unsafe to use. Figure out why / if we really want HTML here instead of text
                    .html(label)
                ;
                return $option;
            },
            selectOptionList: function(item) {
                var options = item.options || [];
                if (!_.isArray(options)) {
                    console.warn("Passing an option mapping is deprecated (order cannot be guaranteed). Use a list.", options);
                    // legacy fun time: keys are used as labels, mapped values used as submit values
                    options = _.map(options, function(x, key) {
                        return {value: x, label: key};
                    });
                }
                var optionElements = [];
                for (var i = 0; i < options.length; ++i) {
                    optionElements.push(this.selectOption(item, options[i]));
                }
                return optionElements;
            },
            select: function(item) {
                var select = $('<select class="form-control"/>');
                var container = this.input(item, select);
                var value = item.value;

                container.addClass('select-container');

                select.append(this.selectOptionList(item));
                if (item.multiple) {
                    select.prop('multiple', true);
                    var separator = item.separator || ',';
                    if (value && !$.isArray(value)) {
                        value = value.split(separator);
                    }
                    select.attr('data-visui-multiselect-separator', separator);
                    select.val(value || null);
                } else {
                    if (value || !isRequiredInput(item)) {
                        select.val(value || "");
                    }
                }
                if ((item.multiple || item.select2) && (typeof select.select2 === 'function')) {
                    select.select2(item);
                }

                return container;
            },
            image: function(item) {
                var image = $('<img src="' + (has(item, 'src') ? item.src : '') + '"/>');
                image.attr('data-preview-for', item.name || null);
                var subContainer = $("<div class='sub-container'/>");
                var label = item.title && this.label(item);
                var container = wrapGroup([label, image], false);

                container.append(subContainer.append(image.detach()));
                container.addClass("image-container");

                if(has(item, 'enlargeImage') && item.enlargeImage) {
                    image.attr('tabindex', 0);
                    image.css('cursor', 'pointer');
                    image.on('keypress click', function(e) {
                        if(e.type !== 'click' && e.which && e.which !== 13) {
                            return
                        }

                        var bigImage = new Image();
                        bigImage.src = item.src;
                        bigImage.onload = function() {
                            var dialog = $('<div>');
                            var bImage = $('<img src="' + image.attr('src') + '"/>');
                            var _popupConfig = {
                                title: image.title ? image.title : 'Image',
                                width: bigImage.width
                            };
                            var maxHeight = $(window).height() - 100;
                            if(bigImage.height > maxHeight) {
                                _popupConfig.height = maxHeight;
                            }
                            dialog.popupDialog(_popupConfig);
                            bImage.css({
                                height:      'auto',
                                width:       '100%',
                                'max-width': bigImage.width
                            });
                            dialog.append(bImage);
                        };
                    })
                }

                if(has(item, 'imageCss')) {
                    image.css(item['imageCss']);
                } else {
                    image.css({width: "100%"});
                }
                return container;
            },
            file: function(item) {
                var input = $('<input type="hidden"  />');
                var fileInput = $('<input type="file" />');
                var container = this.input(item, input);
                var defaultText = (has(item, 'text') ? item.text : "Select");
                var textSpan = '<span class="upload-button-text"><i class="fa fa-upload" aria-hidden="true"/> ' + defaultText + '</span>';
                var uploadButton = $('<span class="btn btn-success button fileinput-button">' + textSpan + '</span>');
                var buttonContainer = $("<div/>");
                var progressBar = $("<div class='progress-bar'/>");
                var eventHandlers = item.on ? item.on : {};

                if(has(item, 'accept')) {
                    fileInput.attr('accept', item.accept);
                }

                //input.detach();
                container.addClass("file-container");
                uploadButton.append(fileInput);
                buttonContainer.append(uploadButton);
                uploadButton.append(progressBar);
                container.append(buttonContainer);

                function truncate(n, len) {
                    var ext = n.substring(n.lastIndexOf(".") + 1, n.length).toLowerCase();
                    var filename = n.replace('.' + ext, '');
                    if(filename.length <= len) {
                        return n;
                    }
                    filename = filename.substr(0, len) + (n.length > len ? '[...]' : '');
                    return filename + '.' + ext;
                }

                fileInput.fileupload({
                    dataType:    'json',
                    url:         item.uploadHanderUrl,
                    formData:    item.formData,
                    //sequentialUploads: true,
                    add:         function(e, data) {
                        //console.log("added file", data, e);
                        data.submit();
                    },
                    progressall: function(e, data) {
                        var progress = parseInt(data.loaded / data.total * 100, 10);
                        progressBar.css({width: progress + "%"});
                        //progressBar.html(progress + "%");
                        if(eventHandlers.progressall){
                            console.error("Using Javascript code in the configuration is deprecated",eventHandlers.progressall);
                            eval(eventHandlers.progressall);
                        }
                    },
                    always:      function(e, data) {
                        if(eventHandlers.always) {
                            console.error("Using Javascript code in the configuration is deprecated",eventHandlers.always);
                            eval(eventHandlers.always);
                        }
                    },
                    done:        function(e, data) {
                        if(eventHandlers.done){
                            console.error("Using Javascript code in the configuration is deprecated",eventHandlers.done);
                            eval(eventHandlers.done);
                        }
                        progressBar.css({width: 0});
                    },
                    success:     function(result, textStatus, jqXHR) {
                        if(eventHandlers.success){
                            console.error("Using Javascript code in the configuration is deprecated",eventHandlers.success);
                            eval(eventHandlers.success);
                        }

                        if(result.files && result.files[0]) {
                            var fileInfo = result.files[0];
                            var img = container.closest('.vis-ui').find('img[data-preview-for="' + item.name + '"]');

                            if(fileInfo.error) {
                                $.notify(fileInfo.error, "error");
                                return;
                            }

                            if(fileInfo.name) {
                                buttonContainer.find('.upload-button-text').html('<i class="fa fa-check-circle-o far-check-circle" aria-hidden="true"/> ' + truncate(fileInfo.name, 10));
                                var newUploadFileInput = container.find('input[type="file"]')
                                    .attr('title', fileInfo.name)
                                    .attr('alt', fileInfo.name)
                                    .attr('label', fileInfo.name);
                            }

                            if(img.size()){
                                img.attr('src', fileInfo.thumbnailUrl);
                            }
                            input.val(fileInfo.url);
                        }
                    }
                });

                return container;
            },
            tabs: function(item) {
                var $tabList = $('<ul/>');
                var container = $('<div/>').append($tabList);
                var children = item.children || [];
                for (var i = 0; i < children.length; ++i) {
                    var subItem = children[i];
                    var panelContent = this.genElement_(this, subItem);
                    var $panel = $('<div>').uniqueId().append(panelContent);
                    var $tabHeader = $('<li>').append($('<a>').attr('href', '#' + $panel.attr('id')).text(subItem.title));
                    $tabList.append($tabHeader);
                    container.append($panel);
                }
                container.tabs({
                    classes: {
                        "ui-tabs": "ui-tabs mapbender-element-tab-navigator",
                        "ui-tabs-nav": "ui-tabs-nav nav nav-tabs",
                        "ui-tabs-panel": "ui-tabs-panel tab-content"
                    }
                });
                return container;
            },
            fieldSet: function(item) {
                var fieldSet = $("<fieldset class='form-group'/>");

                if (item.title) {
                    fieldSet.append(this.label(item));
                }
                if(has(item, 'legend')) {
                    fieldSet.append("<legend>"+item.legend+"</legend>");
                }
                fieldSet.append(this.genElements_(this, item.children || []));

                if (item.breakLine) {
                    fieldSet.append(this.breakLine(item));
                }

                return fieldSet;
            },
            date: function(item) {
                var value = item.value;
                if (item.dateFormat && item.dateFormat !== 'yy-mm-dd') {
                    console.warn("Ignoring invalid dateFormat setting. The only possible value is 'yy-mm-dd'. See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input/date", item);
                }
                if (value === null || (typeof value === 'undefined')) {
                    value = '';
                }
                if (value !== '' && !(typeof value === 'string' && value.match(/^\d{4}-\d{2}-\d{2}$/))) {
                    if (!(typeof value === 'string' && value.match(/^\d{4}-\d{2}-\d{2}$/))) {
                        console.error("Invalid value for date input, ignoring", value);
                        value = '';
                    }
                }
                if (item.mandatory && !value) {
                    value = (new Date()).toISOString().slice(0, 10);
                }

                if (browserSupportsHtml5Date) {
                    return this.input($.extend({}, item, {
                        type: 'date',
                        value: value
                    }));
                } else {
                    var textInput = this.input($.extend({}, item, {
                        type: 'text',
                        value: value
                    }));
                    textInput.dateSelector();
                    return textInput;
                }
            },
            colorPicker: function(item) {
                var container = $('<div class="form-group"/>');
                var inputHolder = this.input(item);
                var label = inputHolder.find('> label');

                inputHolder.append('<span class="input-group-addon"><i></i></span>');
                inputHolder.addClass("input-group colorpicker-element colorpicker-component");
                container.prepend(label);
                container.append(inputHolder);
                inputHolder.find('> label').remove();

                if (item.value) {
                    item.color = item.value;
                }

                if(!item.hasOwnProperty("format")){
                    item.format = "hex";
                }

                inputHolder.colorpicker(item);

                var input = inputHolder.find("input");
                input.addClass("form-control");

                return container;
            },
            slider: function(item) {
                var container = $('<div class="form-group input-group slider-holder"/>');
                var inputHolder = this.input(item);
                var label = inputHolder.find('> label');
                var input = inputHolder.find('> input');
                var sliderRange = $('<div class="input-group"/>');

                label.append('<span/>')

                inputHolder.prepend(sliderRange);
                inputHolder.find('> label').remove();
                inputHolder.find('> input').attr('type', 'hidden');

                container.prepend(label);
                container.append(inputHolder);

                label.find('> span').text(' ' + item.value);

                sliderRange.slider($.extend({
                    range:  "max",
                    min:    1,
                    max:    10,
                    value:  1,
                    step:   1,
                    slide:  function(event, ui) {
                        input.val(ui.value);
                        label.find('> span').text(' ' + ui.value);
                    },
                    change: function(event, ui) {
                        var value = input.val();
                        label.find('> span').text(' ' + value);
                    }
                }, item));

                input.on('change', function() {
                    var value = input.val();
                    label.find('> span').text(' ' + value);
                    sliderRange.slider("value", value);
                });

                return container;
            },
            resultTable: function(item) {
                var container = $("<div/>").attr(item.attr || {});
                $.each(['name'], function(i, key) {
                    if(has(item, key)) {
                        container.attr(key, item[key]);
                    }
                });

                return container
                    // @todo: remove excessive data bindings
                    .data('declaration', item)
                    .resultTable($.extend({
                        lengthChange: false,
                        pageLength:   10,
                        searching:    false,
                        info:         true,
                        processing:   false,
                        ordering:     true,
                        paging:       true,
                        selectable:   false,
                        autoWidth:    false
                    }, item));
            },
            digitizingToolSet: function(item) {
                var $div = $("<div/>").attr(item.attr || {});
                // @todo: remove excessive data bindings
                $div.data('declaration',item);
                return $div.digitizingToolSet(item);
            },

            /**
             * Break line
             *
             * @param item
             * @return {*|HTMLElement}
             */
            breakLine: function(item) {
                return $("<hr/>").attr(item.attr || {}).addClass('break-line');
            },

            /**
             *
             * @param item
             */
            text: function(item) {
                var callback;
                if (!item.text) {
                    console.error('Missing value property .text for type "text" item', item);
                    throw new Error('Missing value property .text for type "text" item');
                }
                var text = $('<div/>').attr(item.attr || {}).addClass('text -visui-text-callback');
                if (typeof item.text === 'function') {
                    callback = function(values) {
                        return (item.text)(values);
                    };
                } else {
                    console.warn("Using eval'd JavaScript code for item type text is deprecated. Supply a function.", item);
                    callback = function(values) {
                        try {
                            var data = values;  // for eval scope
                            var declaration = item; // for eval scope
                            return eval(item.text);
                        } catch (e) {
                            console.error('Failed to evaluate text type item content', item.text, item, values);
                            throw new Error('Failed to evaluate text type item content');
                        }
                    };
                }
                text.data('visui-text-callback', callback);
                var container = this.input(item, text);
                container.addClass('text');
                return container;
            },

            /**
             * Simple container
             *
             * @param item
             * @todo v0.2.x: remove this
             */
            container: function(item) {
                console.warn("Generating a type: container via vis-ui.js is deprecated and will be removed in v0.2", item);
                var container = $('<div/>').attr(item.attr || {}).addClass('form-group');
                container.append(this.genElements_(this, item.children || []));
                return container;
            },

            /**
             * Simple accordion
             *
             * @param item
             * @todo v0.2.x: remove this
             */
            accordion: function(item) {
                console.warn("Generating a type: accordion via vis-ui.js is deprecated and will be removed in v0.2", item);
                var declarations = this;
                var container = $('<div class="accordion"/>');
                if(has(item, 'children')) {
                    _.each(item.children, function(child, k) {
                        var pageContainer = $("<div class='container' data-id='" + k + "'/>");
                        var pageHeader = $("<h3 class='header' data-id='" + k + "'/>");

                        if(has(child, 'head')) {
                            pageHeader.append(declarations.genElement_(declarations, child.head));
                        }

                        if(has(child, 'content')) {
                            pageContainer.append(this.genElement_(declarations, child.content));
                        }

                        container.append(pageHeader);
                        container.append(pageContainer);
                    })
                }
                // @todo: remove excessive data bindings
                container.data('declaration', item);
                container.accordion(item);
                return container;
            }
    });
    $.widget('vis-ui-js.generateElements', {
        options:      {},
        /**
         * Constructor
         *
         * @private
         */
        _create: function() {
            this.element.addClass('vis-ui');
            this.element.on('click touch press', '.-visui-infotext[title]', function(evt) {
                evt.stopPropagation();
                $.notify($(this).attr('title'), 'info');
            });
            this.element.on('click', '.-visui-copytoclipboard', function(evt) {
                evt.stopPropagation();
                var $input = $('input, select, textarea', $(this).closest('.form-group'));
                copyToClipboard($input.val());
            });
            this._setOptions(this.options);
        },

        /**
         * Generate element by declaration
         *
         * @param item declaration
         * @return jquery html object
         */
        genElement: function(item) {
            return genElement_(this.declarations, item);
        },

        /**
         * Generate elements
         *
         * @param element jQuery object
         * @param children declarations
         */
        genElements: function(element, children) {
            element.append(genElements_(this.declarations, children));
        },

        /**
         * Set options
         *
         * @param options
         * @private
         * @todo: this should be _create (minus options argument)
         */
        _setOptions: function(options) {
            // always deep-copy to prevent monkey-patches affecting other instances
            // Re-add readOnlyDeclarations on top to prevent overrides.
            this.declarations = $.extend({}, defaultDeclarations, options.declarations, readOnlyDeclarations);
            if (options.type && !options.children) {
                console.warn("Invocation of generateElements (plural!) with single item is deprecated. Put your item in a list and pass it in the children property.");
                this.genElements(this.element, [options]);
            } else if(has(options, 'children')) {
                this.genElements(this.element, options.children);
            }
            this._super(options);
            this.refresh();
        },

        /**
         * Refresh generated elements
         */
        refresh:     function() {
            this._trigger('refresh');
        }
    });

    /**
     * Update existing select element
     *
     * @param values
     * @param idKey
     * @param valueKey
     */
    $.fn.updateSelect = function(values, idKey, valueKey) {
        var select = this;
        var val = select.val();
        select.empty();

        if(idKey && valueKey){
            values = _.object(_.pluck(values, idKey), _.pluck(values, valueKey));
        }

        _.each(values, function(value, key) {
            select.append('<option value="'+key+'">'+value+'</option>');
        });

        select.val(val);
    };

    /**
     * Grabbed from here: http://jsfiddle.net/DkHyd/
     */
    $.fn.togglepanels = function(args) {
        return this.each(function() {
            $(this).addClass("ui-accordion ui-accordion-icons ui-widget ui-helper-reset")
                .find("h3")
                .addClass("ui-accordion-header ui-helper-reset ui-state-default ui-corner-top ui-corner-bottom")
                .hover(function() {
                    $(this).toggleClass("ui-state-hover");
                })
                .prepend('<span class="ui-icon ui-icon-triangle-1-e"></span>')
                .click(function(e) {
                    $(this)
                        .toggleClass("ui-accordion-header-active ui-state-active ui-state-default ui-corner-bottom")
                        .find("> .ui-icon").toggleClass("ui-icon-triangle-1-e ui-icon-triangle-1-s").end()
                        .next().slideToggle(0);

                    if(args.onChange) {
                        var title = $(e.currentTarget);
                        args.onChange(e, {
                            'title':   title,
                            'content': title.next()
                        });
                    }
                    return false;
                })
                .next()
                .addClass("ui-accordion-content ui-helper-reset ui-widget-content ui-corner-bottom")
                .hide();
        });
    };

})(jQuery);
