# Json Serializer for PHP

[![Build Status](https://travis-ci.org/zumba/json-serializer.png)](https://travis-ci.org/zumba/json-serializer)
[![Code Coverage](https://scrutinizer-ci.com/g/zumba/json-serializer/badges/coverage.png?s=56e61922c00f25b9afae3e97af853f3eb68d9c1a)](https://scrutinizer-ci.com/g/zumba/json-serializer/)
[![Scrutinizer Quality Score](https://scrutinizer-ci.com/g/zumba/json-serializer/badges/quality-score.png?s=16511f820e0c53cdcbbbc62b5de07d493ded1181)](https://scrutinizer-ci.com/g/zumba/json-serializer/)

This is a library to serialize PHP variables in JSON format. It is similar of the `serialize()` function in PHP,
but the output is a string JSON encoded. You can also unserialize the JSON generated by this tool and have you
PHP content back.

Supported features:
- Encode/Decode of scalar, null, array
- Encode/Decode of objects
- Support nested serialization
- Support not declared properties on the original class definition (ie, properties in `stdClass`)
- Support object recursion

Unsupported serialization content:
- Resource (ie, `fopen()` response)
- Closures

This project should not be confused with `JsonSerializable` interface from PHP 5.4. This interface is used on
`json_encode` to encode the objects. There is no unserialization with this interface, differently from this project.

*Json Serializer requires PHP >= 5.3.6*

## Example

```php

class MyCustomClass {
	public $isItAwesome = true;
	protected $nice = 'very!';
}

$instance = new MyCustomClass();

$serializer = new Zumba\Util\JsonSerializer();
$json = $serializer->serialize($instance);
// $json will contain the content {"@type":"MyCustomClass","isItAwesome":true,"nice":"very!"}

$restoredInstance = $serializer->unserialize($json);
// $restoredInstance will be an instance of MyCustomClass
```

## How to Install

If you are using composer, install the package [`zumba/json-serializer`](https://packagist.org/packages/zumba/json-serializer).

```
$ composer require zumba/json-serializer
```

Or add the `zumba/json-serializer` directly in your `composer.json` file.

If you are not using composer, you can just copy the files from `src` folder in your project.

## Special Note for PHP 5.3

In order to support unescaped unicode characters, it is recommended to have the `mbstring` installed, otherwise unicode characters
will be escaped in the format of `\uXXXX`.
